/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.result;

import com.duckblade.osrs.dpscalc.calc.AttackSpeedComputable;
import com.duckblade.osrs.dpscalc.calc.DpsComputable;
import com.duckblade.osrs.dpscalc.calc.HitChanceComputable;
import com.duckblade.osrs.dpscalc.calc.TimeToKillComputable;
import com.duckblade.osrs.dpscalc.calc.attack.AttackRollComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.defender.DefenseRollComputable;
import com.duckblade.osrs.dpscalc.calc.exceptions.DpsComputeException;
import com.duckblade.osrs.dpscalc.calc.exceptions.MissingInputException;
import com.duckblade.osrs.dpscalc.calc.maxhit.BaseMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.TrueMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.prayer.PrayerDurationRemainingComputable;
import com.duckblade.osrs.dpscalc.plugin.ui.result.CalcResultLabel;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CalcResultPanel
extends JPanel
implements StateBoundComponent {
    private static final Logger log = LoggerFactory.getLogger(CalcResultPanel.class);
    private static final DecimalFormat DPS_FORMAT = new DecimalFormat("'DPS:' #.###");
    private static final DecimalFormat ROLL_FORMAT = new DecimalFormat("#,###");
    private static final DecimalFormat HIT_CHANCE_FORMAT = new DecimalFormat("#.#%");
    private static final DecimalFormat HIT_RATE_FORMAT = new DecimalFormat("#.# 'secs'");
    private final PanelStateManager manager;
    private final DpsComputable dpsComputable;
    private final JLabel dpsValue;
    private static final String DPS_CALC_FAIL = "DPS: ???";
    private final List<CalcResultLabel> resultLabels;
    private final JTextArea warningsLabel;

    private static String timeFormat(Duration duration) {
        if (duration == null) {
            return "Infinity";
        }
        return DurationFormatUtils.formatDuration((long)duration.toMillis(), (String)"mm:ss", (boolean)true);
    }

    @Inject
    public CalcResultPanel(PanelStateManager manager, DpsComputable dpsComputable, AttackRollComputable attackRollComputable, DefenseRollComputable defenseRollComputable, BaseMaxHitComputable baseMaxHitComputable, TrueMaxHitComputable trueMaxHitComputable, HitChanceComputable hitChanceComputable, AttackSpeedComputable attackSpeedComputable, TimeToKillComputable timeToKillComputable, PrayerDurationRemainingComputable prayerDurationRemainingComputable) {
        this.manager = manager;
        this.dpsComputable = dpsComputable;
        this.setLayout(new BoxLayout(this, 1));
        Font originalBold = FontManager.getRunescapeBoldFont();
        Font dpsFont = originalBold.deriveFont((float)originalBold.getSize() * 2.0f);
        this.dpsValue = new JLabel(DPS_CALC_FAIL, 0);
        this.dpsValue.setAlignmentX(0.5f);
        this.dpsValue.setForeground(Color.white);
        this.dpsValue.setFont(dpsFont);
        this.add(this.dpsValue);
        this.add(Box.createVerticalStrut(5));
        this.resultLabels = Arrays.asList(new CalcResultLabel("Max Attack Roll:", ctx -> ROLL_FORMAT.format(ctx.get(attackRollComputable))), new CalcResultLabel("NPC Defense Roll:", ctx -> ROLL_FORMAT.format(ctx.get(defenseRollComputable))), new CalcResultLabel("Hit Chance:", ctx -> HIT_CHANCE_FORMAT.format(ctx.get(hitChanceComputable))), new CalcResultLabel("Max Hit:", ctx -> String.valueOf(ctx.get(trueMaxHitComputable))), new CalcResultLabel("Base Max Hit:", ctx -> {
            int baseMaxHit = ctx.get(baseMaxHitComputable);
            if (baseMaxHit < ctx.get(trueMaxHitComputable)) {
                return String.valueOf(baseMaxHit);
            }
            return null;
        }), new CalcResultLabel("Attack Every:", ctx -> HIT_RATE_FORMAT.format((double)ctx.get(attackSpeedComputable).intValue() / 0.6)), new CalcResultLabel("Avg TTK:", ctx -> CalcResultPanel.timeFormat(ctx.get(timeToKillComputable))), new CalcResultLabel("Prayer Lasts:", ctx -> CalcResultPanel.timeFormat(ctx.get(prayerDurationRemainingComputable))));
        this.resultLabels.subList(0, 3).forEach(this::add);
        this.add(Box.createVerticalStrut(10));
        this.resultLabels.subList(3, 5).forEach(this::add);
        this.add(Box.createVerticalStrut(10));
        this.resultLabels.subList(6, 8).forEach(this::add);
        this.add(Box.createVerticalStrut(20));
        this.warningsLabel = new JTextArea();
        this.warningsLabel.setFont(FontManager.getRunescapeBoldFont().deriveFont(2));
        this.warningsLabel.setLineWrap(true);
        this.warningsLabel.setMaximumSize(new Dimension(225, 2000));
        this.warningsLabel.setVisible(false);
        this.warningsLabel.setFocusable(false);
        this.warningsLabel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.add(this.warningsLabel);
    }

    @Override
    public void fromState() {
        block2: {
            try {
                ComputeContext ctx = new ComputeContext(this.getState().toComputeInput());
                double dps = ctx.get(this.dpsComputable);
                this.dpsValue.setText(DPS_FORMAT.format(dps));
                this.resultLabels.forEach(l -> l.setValue(ctx));
                List<String> warnings = ctx.getWarnings();
                this.warningsLabel.setText(String.join((CharSequence)"\n\n", warnings));
                this.warningsLabel.setVisible(!warnings.isEmpty());
            }
            catch (DpsComputeException e) {
                log.debug("Failed compute: ", (Throwable)e);
                this.clear();
                if (e.getCause() instanceof MissingInputException) break block2;
                throw e;
            }
        }
    }

    public void clear() {
        this.dpsValue.setText(DPS_CALC_FAIL);
        this.resultLabels.forEach(l -> l.setValue(null));
        this.warningsLabel.setVisible(false);
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

