/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.result;

import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.exceptions.DpsComputeException;
import com.duckblade.osrs.dpscalc.calc.exceptions.MissingInputException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.function.Function;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.FontManager;

public class CalcResultLabel
extends JPanel {
    private final Function<ComputeContext, String> getter;
    private final JLabel valueLabel;

    public CalcResultLabel(String title, Function<ComputeContext, String> getter) {
        this.getter = getter;
        this.setLayout(new BoxLayout(this, 0));
        this.setMaximumSize(new Dimension(213, 20));
        this.setVisible(false);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(FontManager.getRunescapeBoldFont());
        titleLabel.setForeground(Color.white);
        this.add(titleLabel);
        Component glue = Box.createHorizontalGlue();
        glue.setBackground(Color.pink);
        this.add(glue);
        this.valueLabel = new JLabel(title);
        this.valueLabel.setFont(FontManager.getRunescapeBoldFont());
        this.valueLabel.setForeground(Color.white);
        this.add(this.valueLabel);
    }

    public void setValue(ComputeContext context) {
        block3: {
            if (context == null) {
                this.setDisplay(null);
                return;
            }
            try {
                this.setDisplay(this.getter.apply(context));
            }
            catch (DpsComputeException e) {
                this.setDisplay(null);
                if (e.getCause() instanceof MissingInputException) break block3;
                throw e;
            }
        }
    }

    private void setDisplay(String newValue) {
        this.valueLabel.setText(newValue);
        this.setVisible(newValue != null);
    }
}

