/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.prayer;

import com.duckblade.osrs.dpscalc.calc.model.Prayer;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class PrayerButton
extends JPanel
implements StateBoundComponent {
    private static final Image SELECTED_BACKGROUND = ImageUtil.loadImageResource(PrayerButton.class, (String)"activated_background.png");
    private static final int WIDTH = 34;
    private static final int HEIGHT = 34;
    private final Prayer prayer;
    private final PanelStateManager manager;
    private final ImageIcon selectedIcon;
    private final ImageIcon deselectedIcon;
    private final JButton button;
    private boolean selected;
    private final List<Runnable> callbacks = new ArrayList<Runnable>();

    private static BufferedImage createSelectedGraphic(Image prayerIcon) {
        BufferedImage selectedIcon = new BufferedImage(34, 34, 6);
        Graphics g = selectedIcon.getGraphics();
        g.drawImage(SELECTED_BACKGROUND, 0, 0, null);
        g.drawImage(prayerIcon, 0, 0, null);
        g.dispose();
        return selectedIcon;
    }

    public PrayerButton(PanelStateManager manager, Prayer prayer) {
        this.manager = manager;
        this.prayer = prayer;
        this.callbacks.add(this::toState);
        String iconFileName = prayer.name().toLowerCase() + ".png";
        BufferedImage deselected = ImageUtil.loadImageResource(this.getClass(), (String)iconFileName);
        this.deselectedIcon = new ImageIcon(deselected);
        this.selectedIcon = new ImageIcon(PrayerButton.createSelectedGraphic(deselected));
        this.button = new JButton(this.deselectedIcon);
        SwingUtil.removeButtonDecorations((AbstractButton)this.button);
        this.button.setMinimumSize(new Dimension(34, 34));
        this.button.setPreferredSize(new Dimension(34, 34));
        this.button.setMaximumSize(new Dimension(34, 34));
        this.button.addActionListener(e -> {
            this.setSelected(!this.selected);
            this.callbacks.forEach(Runnable::run);
        });
        this.add(this.button);
    }

    private void setSelected(boolean newValue) {
        this.selected = newValue;
        this.button.setIcon(this.selected ? this.selectedIcon : this.deselectedIcon);
    }

    @Override
    public void toState() {
        if (this.selected) {
            this.getState().getAttackerPrayers().add(this.prayer);
        } else {
            this.getState().getAttackerPrayers().remove((Object)this.prayer);
        }
    }

    @Override
    public void fromState() {
        this.setSelected(this.getState().getAttackerPrayers().contains((Object)this.prayer));
    }

    public void addCallback(Runnable r) {
        this.callbacks.add(r);
    }

    public Prayer getPrayer() {
        return this.prayer;
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

