/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.npc;

import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.defender.skills.TheatreEntryModeSkillScaling;
import com.duckblade.osrs.dpscalc.calc.defender.skills.TheatreSkillScaling;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateVisibleComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.ComputeUtil;
import com.duckblade.osrs.dpscalc.plugin.ui.util.FocusLostAdapter;
import com.duckblade.osrs.dpscalc.plugin.ui.util.JTextFieldIntOnlyKeyAdapter;
import com.duckblade.osrs.dpscalc.plugin.ui.util.SelectAllFocusListener;
import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

@Singleton
public class RaidPartySizePanel
extends JPanel
implements StateBoundComponent,
StateVisibleComponent {
    private final PanelStateManager manager;
    private final TheatreSkillScaling theatreSkillScaling;
    private final TheatreEntryModeSkillScaling theatreEntryModeSkillScaling;
    private final JTextField partySizeField;
    private final List<Runnable> callbacks = new ArrayList<Runnable>();

    @Inject
    public RaidPartySizePanel(PanelStateManager manager, TheatreSkillScaling theatreSkillScaling, TheatreEntryModeSkillScaling theatreEntryModeSkillScaling) {
        this.manager = manager;
        this.theatreSkillScaling = theatreSkillScaling;
        this.theatreEntryModeSkillScaling = theatreEntryModeSkillScaling;
        this.setMinimumSize(new Dimension(200, 40));
        this.setMaximumSize(new Dimension(200, 40));
        this.setLayout(new GridLayout(2, 2));
        this.setVisible(false);
        this.partySizeField = new JTextField("1", 2);
        this.partySizeField.setAlignmentX(0.5f);
        this.partySizeField.setHorizontalAlignment(0);
        this.partySizeField.addFocusListener(new SelectAllFocusListener(this.partySizeField));
        this.partySizeField.addKeyListener(new JTextFieldIntOnlyKeyAdapter());
        this.partySizeField.addFocusListener(new FocusLostAdapter(e -> this.onChange()));
        this.partySizeField.addActionListener(e -> this.onChange());
        this.add(new JLabel("Party Size"));
        this.add(this.partySizeField);
        this.add(Box.createVerticalStrut(10));
    }

    private void onChange() {
        this.toState();
        this.callbacks.forEach(Runnable::run);
    }

    @Override
    public void toState() {
        this.coerce();
        this.getState().setRaidPartySize(Integer.parseInt(this.partySizeField.getText()));
    }

    @Override
    public void fromState() {
        this.partySizeField.setText(String.valueOf(this.getState().getRaidPartySize()));
    }

    @Override
    public void updateVisibility() {
        ComputeUtil.computeSilent(() -> {
            ComputeContext ctx = new ComputeContext();
            ctx.put(ComputeInputs.DEFENDER_ATTRIBUTES, this.getState().getDefenderAttributes().toImmutable());
            this.setVisible(this.theatreSkillScaling.isApplicable(ctx) || this.theatreEntryModeSkillScaling.isApplicable(ctx));
        });
    }

    private void coerce() {
        if (Strings.isNullOrEmpty((String)this.partySizeField.getText())) {
            this.partySizeField.setText("1");
        }
    }

    public void addCallback(Runnable r) {
        this.callbacks.add(r);
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

