/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.npc;

import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.plugin.osdata.clientdata.ClientDataProviderThreadProxy;
import com.duckblade.osrs.dpscalc.plugin.ui.npc.NpcAttributesPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.npc.NpcBonusesPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.npc.NpcSelectPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.npc.NpcSkillsPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.npc.RaidPartySizePanel;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelState;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.CustomJCheckBox;
import com.duckblade.osrs.dpscalc.plugin.ui.util.LoadFromClientButton;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@Singleton
public class NpcStatsPanel
extends JPanel
implements StateBoundComponent {
    private final PanelStateManager manager;
    private final ClientDataProviderThreadProxy clientDataProviderThreadProxy;
    private final CustomJCheckBox manualEntry;
    private final NpcSelectPanel npcSelectPanel;
    private final RaidPartySizePanel raidPartySizePanel;
    private final NpcSkillsPanel npcSkillsPanel;
    private final NpcBonusesPanel npcBonusesPanel;
    private final NpcAttributesPanel npcAttributesPanel;

    @Inject
    public NpcStatsPanel(PanelStateManager manager, ClientDataProviderThreadProxy clientDataProviderThreadProxy, NpcSelectPanel npcSelectPanel, RaidPartySizePanel raidPartySizePanel, NpcSkillsPanel npcSkillsPanel, NpcBonusesPanel npcBonusesPanel, NpcAttributesPanel npcAttributesPanel) {
        this.manager = manager;
        this.raidPartySizePanel = raidPartySizePanel;
        this.clientDataProviderThreadProxy = clientDataProviderThreadProxy;
        this.setLayout(new BoxLayout(this, 1));
        this.add(new LoadFromClientButton(this::loadFromClient));
        this.manualEntry = new CustomJCheckBox("Manual Entry Mode");
        this.manualEntry.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.manualEntry.addCallback(() -> this.setManualMode(this.manualEntry.getValue()));
        this.add(this.manualEntry);
        this.add(Box.createVerticalStrut(5));
        this.npcSelectPanel = npcSelectPanel;
        npcSelectPanel.addCallback(this::fromState);
        this.add(npcSelectPanel);
        raidPartySizePanel.addCallback(this::fromState);
        this.add(raidPartySizePanel);
        this.npcSkillsPanel = npcSkillsPanel;
        this.add(npcSkillsPanel);
        this.npcBonusesPanel = npcBonusesPanel;
        this.add(npcBonusesPanel);
        this.npcAttributesPanel = npcAttributesPanel;
        this.add(npcAttributesPanel);
    }

    public void setManualMode(boolean manualMode) {
        if (!manualMode) {
            this.npcSelectPanel.setValue(null);
        }
        this.npcSelectPanel.setVisible(!manualMode);
        this.npcSkillsPanel.setEditable(manualMode);
        this.npcBonusesPanel.setEditable(manualMode);
        this.npcAttributesPanel.setEditable(manualMode);
    }

    public void loadFromClient() {
        this.clientDataProviderThreadProxy.tryAcquire(clientDataProvider -> {
            Skills s = clientDataProvider.getNpcTargetSkills();
            this.getState().setDefenderSkills(s != null ? s.getTotals() : Skills.EMPTY.getTotals());
            this.getState().setDefenderBonuses(PanelState.MutableDefensiveBonuses.fromImmutable(clientDataProvider.getNpcTargetBonuses()));
            this.getState().setDefenderAttributes(PanelState.MutableDefenderAttributes.fromImmutable(clientDataProvider.getNpcTargetAttributes()));
            SwingUtilities.invokeLater(this::fromState);
        });
    }

    @Override
    public void toState() {
        this.raidPartySizePanel.toState();
        if (!this.manualEntry.getValue()) {
            this.npcSelectPanel.toState();
            this.npcSkillsPanel.fromScaled();
            return;
        }
        this.npcSkillsPanel.toState();
        this.npcBonusesPanel.toState();
        this.npcAttributesPanel.toState();
    }

    @Override
    public void fromState() {
        this.raidPartySizePanel.fromState();
        this.raidPartySizePanel.updateVisibility();
        if (!this.manualEntry.getValue()) {
            this.npcSelectPanel.fromState();
            this.npcSkillsPanel.fromScaled();
            this.npcBonusesPanel.fromState();
            this.npcAttributesPanel.fromState();
            return;
        }
        this.npcSkillsPanel.fromState();
        this.npcBonusesPanel.fromState();
        this.npcAttributesPanel.fromState();
    }

    public boolean isReady() {
        return this.manualEntry.getValue() || this.npcSelectPanel.getValue() != null;
    }

    public String getSummary() {
        if (!this.isReady()) {
            return "Not Set";
        }
        if (this.manualEntry.getValue()) {
            return "Entered Manually";
        }
        return this.getState().getDefenderAttributes().getName();
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

