/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.npc;

import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.defender.DefenderSkillsComputable;
import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.plugin.ui.skills.StatCategory;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelState;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.component.StateBoundStatBox;
import com.duckblade.osrs.dpscalc.plugin.ui.util.ComputeUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.JPanel;
import net.runelite.api.Skill;

@Singleton
public class NpcSkillsPanel
extends JPanel
implements StateBoundComponent {
    private final PanelStateManager manager;
    private final Map<Skill, StateBoundStatBox> skillBoxes = new HashMap<Skill, StateBoundStatBox>(6);
    private final DefenderSkillsComputable defenderSkillsComputable;

    private static ObjIntConsumer<PanelState> writer(Skill skill) {
        return (state, lvl) -> state.getDefenderSkills().put(skill, lvl);
    }

    private static ToIntFunction<PanelState> reader(Skill skill) {
        return state -> state.getDefenderSkills().getOrDefault(skill, 0);
    }

    @Inject
    public NpcSkillsPanel(PanelStateManager manager, DefenderSkillsComputable defenderSkillsComputable) {
        this.manager = manager;
        this.defenderSkillsComputable = defenderSkillsComputable;
        this.skillBoxes.put(Skill.HITPOINTS, new StateBoundStatBox(manager, "hitpoints", "Hitpoints", false, NpcSkillsPanel.writer(Skill.HITPOINTS), NpcSkillsPanel.reader(Skill.HITPOINTS)));
        this.skillBoxes.put(Skill.ATTACK, new StateBoundStatBox(manager, "att", "Attack", false, NpcSkillsPanel.writer(Skill.ATTACK), NpcSkillsPanel.reader(Skill.ATTACK)));
        this.skillBoxes.put(Skill.STRENGTH, new StateBoundStatBox(manager, "str", "Strength", false, NpcSkillsPanel.writer(Skill.STRENGTH), NpcSkillsPanel.reader(Skill.STRENGTH)));
        this.skillBoxes.put(Skill.DEFENCE, new StateBoundStatBox(manager, "def", "Defence", false, NpcSkillsPanel.writer(Skill.DEFENCE), NpcSkillsPanel.reader(Skill.DEFENCE)));
        this.skillBoxes.put(Skill.MAGIC, new StateBoundStatBox(manager, "mage", "Magic", false, NpcSkillsPanel.writer(Skill.MAGIC), NpcSkillsPanel.reader(Skill.MAGIC)));
        this.skillBoxes.put(Skill.RANGED, new StateBoundStatBox(manager, "range", "Ranged", false, NpcSkillsPanel.writer(Skill.RANGED), NpcSkillsPanel.reader(Skill.RANGED)));
        this.add(new StatCategory("Combat Stats", new ArrayList<StateBoundStatBox>(this.skillBoxes.values())));
        this.add(Box.createVerticalStrut(5));
        this.setMaximumSize(new Dimension(200, 134));
    }

    @Override
    public void toState() {
        this.skillBoxes.values().forEach(StateBoundStatBox::toState);
    }

    @Override
    public void fromState() {
        this.skillBoxes.values().forEach(StateBoundStatBox::fromState);
    }

    public void fromScaled() {
        Skills scaled = ComputeUtil.tryCompute(() -> {
            ComputeContext ctx = new ComputeContext();
            ctx.put(ComputeInputs.DEFENDER_ATTRIBUTES, this.getState().getDefenderAttributes().toImmutable());
            ctx.put(ComputeInputs.DEFENDER_SKILLS, Skills.builder().levels(this.getState().getDefenderSkills()).build());
            ctx.put(ComputeInputs.RAID_PARTY_SIZE, this.getState().getRaidPartySize());
            return ctx.get(this.defenderSkillsComputable);
        });
        if (scaled != null) {
            this.skillBoxes.forEach((s, sbsb) -> sbsb.setValue(scaled.getTotals().getOrDefault(s, 0)));
        } else {
            this.fromState();
        }
    }

    public void setEditable(boolean editable) {
        this.skillBoxes.values().forEach(sbsb -> sbsb.setEditable(editable));
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

