/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.npc;

import com.duckblade.osrs.dpscalc.plugin.ui.skills.StatCategory;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelState;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.component.StateBoundStatBox;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.JPanel;

@Singleton
public class NpcBonusesPanel
extends JPanel
implements StateBoundComponent {
    private final PanelStateManager manager;
    private final List<StateBoundStatBox> statBoxes = new ArrayList<StateBoundStatBox>(5);

    private static ObjIntConsumer<PanelState> writer(ObjIntConsumer<PanelState.MutableDefensiveBonuses> inner) {
        return (state, value) -> inner.accept(state.getDefenderBonuses(), value);
    }

    private static ToIntFunction<PanelState> reader(ToIntFunction<PanelState.MutableDefensiveBonuses> inner) {
        return state -> inner.applyAsInt(state.getDefenderBonuses());
    }

    @Inject
    public NpcBonusesPanel(PanelStateManager manager) {
        this.manager = manager;
        this.statBoxes.add(new StateBoundStatBox(manager, "dstab", "Stab", false, NpcBonusesPanel.writer(PanelState.MutableDefensiveBonuses::setDefenseStab), NpcBonusesPanel.reader(PanelState.MutableDefensiveBonuses::getDefenseStab)));
        this.statBoxes.add(new StateBoundStatBox(manager, "dslash", "Slash", false, NpcBonusesPanel.writer(PanelState.MutableDefensiveBonuses::setDefenseSlash), NpcBonusesPanel.reader(PanelState.MutableDefensiveBonuses::getDefenseSlash)));
        this.statBoxes.add(new StateBoundStatBox(manager, "dcrush", "Crush", false, NpcBonusesPanel.writer(PanelState.MutableDefensiveBonuses::setDefenseCrush), NpcBonusesPanel.reader(PanelState.MutableDefensiveBonuses::getDefenseCrush)));
        this.statBoxes.add(new StateBoundStatBox(manager, "dmagic", "Magic", false, NpcBonusesPanel.writer(PanelState.MutableDefensiveBonuses::setDefenseMagic), NpcBonusesPanel.reader(PanelState.MutableDefensiveBonuses::getDefenseMagic)));
        this.statBoxes.add(new StateBoundStatBox(manager, "drange", "Ranged", false, NpcBonusesPanel.writer(PanelState.MutableDefensiveBonuses::setDefenseRanged), NpcBonusesPanel.reader(PanelState.MutableDefensiveBonuses::getDefenseRanged)));
        this.add(new StatCategory("Defensive Bonuses", this.statBoxes));
        this.add(Box.createVerticalStrut(5));
        this.setMaximumSize(new Dimension(200, 134));
    }

    @Override
    public void toState() {
        this.statBoxes.forEach(StateBoundStatBox::toState);
    }

    @Override
    public void fromState() {
        this.statBoxes.forEach(StateBoundStatBox::fromState);
    }

    public void setEditable(boolean editable) {
        this.statBoxes.forEach(sbsb -> sbsb.setEditable(editable));
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

