/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.npc;

import com.duckblade.osrs.dpscalc.plugin.ui.skills.StatCategory;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelState;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.component.StateBoundJCheckBox;
import com.duckblade.osrs.dpscalc.plugin.ui.state.component.StateBoundStatBox;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

@Singleton
public class NpcAttributesPanel
extends JPanel
implements StateBoundComponent {
    private final PanelStateManager manager;
    private final List<StateBoundStatBox> numericalAttrBoxes = new ArrayList<StateBoundStatBox>(5);
    private final List<StateBoundJCheckBox> booleanAttrBoxes = new ArrayList<StateBoundJCheckBox>(6);

    private static ObjIntConsumer<PanelState> writer(ObjIntConsumer<PanelState.MutableDefenderAttributes> inner) {
        return (state, value) -> inner.accept(state.getDefenderAttributes(), value);
    }

    private static ToIntFunction<PanelState> reader(ToIntFunction<PanelState.MutableDefenderAttributes> inner) {
        return state -> inner.applyAsInt(state.getDefenderAttributes());
    }

    private static BiConsumer<PanelState, Boolean> writer(BiConsumer<PanelState.MutableDefenderAttributes, Boolean> inner) {
        return (state, value) -> inner.accept(state.getDefenderAttributes(), (Boolean)value);
    }

    private static Predicate<PanelState> reader(Predicate<PanelState.MutableDefenderAttributes> inner) {
        return state -> inner.test(state.getDefenderAttributes());
    }

    @Inject
    public NpcAttributesPanel(PanelStateManager manager) {
        this.manager = manager;
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(200, 300));
        this.setMaximumSize(new Dimension(200, 300));
        this.numericalAttrBoxes.add(new StateBoundStatBox(manager, "id", "NPC ID", false, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setNpcId), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::getNpcId)));
        this.numericalAttrBoxes.add(new StateBoundStatBox(manager, "amagic", "Magic Acc.", false, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setAccuracyMagic), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::getAccuracyMagic)));
        this.numericalAttrBoxes.add(new StateBoundStatBox(manager, "size", "Size", false, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setSize), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::getSize)));
        this.add(new StatCategory("Defensive Bonuses", this.numericalAttrBoxes));
        this.add(Box.createVerticalStrut(5));
        JPanel booleanAttrPanel = new JPanel();
        booleanAttrPanel.setLayout(new GridLayout(4, 2));
        this.add(booleanAttrPanel);
        this.booleanAttrBoxes.add(new StateBoundJCheckBox("Demon", manager, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setDemon), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::isDemon)));
        this.booleanAttrBoxes.add(new StateBoundJCheckBox("Dragon", manager, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setDragon), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::isDragon)));
        this.booleanAttrBoxes.add(new StateBoundJCheckBox("Kalphite", manager, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setKalphite), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::isKalphite)));
        this.booleanAttrBoxes.add(new StateBoundJCheckBox("Leafy", manager, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setLeafy), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::isLeafy)));
        this.booleanAttrBoxes.add(new StateBoundJCheckBox("Undead", manager, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setUndead), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::isUndead)));
        this.booleanAttrBoxes.add(new StateBoundJCheckBox("T1 Vampyre", manager, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setVampyre1), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::isVampyre1)));
        this.booleanAttrBoxes.add(new StateBoundJCheckBox("T2 Vampyre", manager, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setVampyre2), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::isVampyre2)));
        this.booleanAttrBoxes.add(new StateBoundJCheckBox("T3 Vampyre", manager, NpcAttributesPanel.writer(PanelState.MutableDefenderAttributes::setVampyre3), NpcAttributesPanel.reader(PanelState.MutableDefenderAttributes::isVampyre3)));
        this.booleanAttrBoxes.forEach(sbsb -> sbsb.setEditable(false));
        this.booleanAttrBoxes.forEach(booleanAttrPanel::add);
    }

    @Override
    public void toState() {
        this.numericalAttrBoxes.forEach(StateBoundStatBox::toState);
    }

    @Override
    public void fromState() {
        this.setPreferredSize(new Dimension(200, 300));
        this.setMaximumSize(new Dimension(200, 300));
        this.numericalAttrBoxes.forEach(StateBoundStatBox::fromState);
    }

    public void setEditable(boolean editable) {
        this.numericalAttrBoxes.forEach(sbsb -> sbsb.setEditable(editable));
        this.booleanAttrBoxes.forEach(sbsb -> sbsb.setEditable(editable));
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

