/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.equip;

import com.duckblade.osrs.dpscalc.calc.AttackerItemStatsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.ComputeUtil;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class EquipmentTotalsPanel
extends JPanel
implements StateBoundComponent {
    private final PanelStateManager manager;
    private final AttackerItemStatsComputable attackerItemStatsComputable;
    private final Set<StatLine> statLines = new HashSet<StatLine>();

    @Inject
    public EquipmentTotalsPanel(PanelStateManager manager, AttackerItemStatsComputable attackerItemStatsComputable) {
        this.manager = manager;
        this.attackerItemStatsComputable = attackerItemStatsComputable;
        this.setMinimumSize(new Dimension(225, 0));
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.5f);
        this.add(Box.createHorizontalGlue());
        this.addLine("Stab Accuracy", ItemStats::getAccuracyStab);
        this.addLine("Slash Accuracy", ItemStats::getAccuracySlash);
        this.addLine("Crush Accuracy", ItemStats::getAccuracyCrush);
        this.addLine("Magic Accuracy", ItemStats::getAccuracyMagic);
        this.addLine("Ranged Accuracy", ItemStats::getAccuracyRanged);
        this.add(Box.createVerticalStrut(10));
        this.addLine("Melee Strength", ItemStats::getStrengthMelee);
        this.addLine("Ranged Strength", ItemStats::getStrengthRanged);
        this.addLine("Magic Damage Bonus", ItemStats::getStrengthMagic);
        this.add(Box.createVerticalStrut(10));
        this.addLine("Weapon Speed", ItemStats::getSpeed);
        this.addLine("Prayer", ItemStats::getPrayer);
    }

    private void addLine(String title, ToDoubleFunction<ItemStats> getter) {
        StatLine line = new StatLine(title, getter);
        this.statLines.add(line);
        this.add(line);
    }

    @Override
    public void fromState() {
        ComputeUtil.computeSilent(() -> {
            AttackStyle attackStyle = this.getState().getAttackStyle();
            if (attackStyle == null) {
                attackStyle = this.getState().getAttackerItems().getOrDefault(EquipmentInventorySlot.WEAPON, ItemStats.EMPTY).getWeaponCategory().getAttackStyles().get(0);
            }
            ComputeContext ctx = new ComputeContext();
            ctx.put(ComputeInputs.ATTACKER_ITEMS, this.getState().getAttackerItems());
            ctx.put(ComputeInputs.ATTACK_STYLE, attackStyle);
            ctx.put(ComputeInputs.BLOWPIPE_DARTS, this.getState().getBlowpipeDarts());
            ItemStats aggregate = ctx.get(this.attackerItemStatsComputable);
            this.statLines.forEach(sl -> sl.update(aggregate));
        });
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }

    private static class StatLine
    extends JLabel {
        private static final DecimalFormat STAT_LABEL_FORMAT = new DecimalFormat(": #.#");
        private final String title;
        private final ToDoubleFunction<ItemStats> getter;

        public StatLine(String title, ToDoubleFunction<ItemStats> getter) {
            super(title + ": 0");
            this.title = title;
            this.getter = getter;
        }

        public void update(ItemStats itemStats) {
            this.setText(this.title + STAT_LABEL_FORMAT.format(this.getter.applyAsDouble(itemStats)));
        }
    }
}

