/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.equip;

import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.ItemStatsProvider;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.component.StateBoundJComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class EquipmentSlotPanel
extends JPanel
implements StateBoundComponent {
    private static final ImageIcon CLEAR_ICON = new ImageIcon(ImageUtil.loadImageResource(EquipmentSlotPanel.class, (String)"icon_clear.png"));
    private final PanelStateManager manager;
    private final ItemManager rlItemManager;
    private final ImageIcon defaultIcon;
    private final JLabel imageLabel;
    private final StateBoundJComboBox<ItemStats> comboBox;

    private static List<ItemStats> getItemsForSlot(ItemStatsProvider itemStatsProvider, int slotIx) {
        return itemStatsProvider.getAll().stream().filter(is -> is.getSlot() == slotIx).sorted(Comparator.comparing(ItemStats::getName)).collect(Collectors.toList());
    }

    public EquipmentSlotPanel(PanelStateManager manager, ItemManager rlItemManager, EquipmentInventorySlot slot, ItemStatsProvider itemStatsProvider) {
        this.manager = manager;
        this.rlItemManager = rlItemManager;
        this.setLayout(new BorderLayout());
        this.setMaximumSize(new Dimension(225, 25));
        this.defaultIcon = new ImageIcon(ImageUtil.resizeImage((BufferedImage)ImageUtil.loadImageResource(this.getClass(), (String)("slot_" + slot.getSlotIdx() + ".png")), (int)25, (int)25));
        this.imageLabel = new JLabel(this.defaultIcon);
        this.imageLabel.setMaximumSize(new Dimension(25, 25));
        this.imageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.add((Component)this.imageLabel, "West");
        this.comboBox = new StateBoundJComboBox<ItemStats>(EquipmentSlotPanel.getItemsForSlot(itemStatsProvider, slot.getSlotIdx()), ItemStats::getName, null, manager, (ps, v) -> {
            if (v == null) {
                ps.getAttackerItems().remove(slot);
            } else {
                ps.getAttackerItems().put(slot, (ItemStats)v);
            }
        }, ps -> ps.getAttackerItems().get(slot));
        this.comboBox.enableAutocomplete();
        this.comboBox.setPreferredSize(new Dimension(150, 25));
        this.comboBox.addCallback(this::updateImage);
        this.add(this.comboBox, "Center");
        JButton clearButton = new JButton(CLEAR_ICON);
        clearButton.setPreferredSize(new Dimension(25, 25));
        SwingUtil.removeButtonDecorations((AbstractButton)clearButton);
        clearButton.addActionListener(e -> {
            this.getState().getAttackerItems().remove(slot);
            this.fromState();
        });
        this.add((Component)clearButton, "East");
    }

    private void updateImage() {
        SwingUtilities.invokeLater(() -> {
            ItemStats newValue = (ItemStats)this.comboBox.getValue();
            if (newValue == null) {
                this.imageLabel.setIcon(this.defaultIcon);
            } else if (this.rlItemManager != null) {
                AsyncBufferedImage newIcon = this.rlItemManager.getImage(newValue.getItemId());
                BufferedImage resized = ImageUtil.resizeImage((BufferedImage)newIcon, (int)25, (int)25);
                newIcon.onLoaded(() -> {
                    BufferedImage resizedDelayed = ImageUtil.resizeImage((BufferedImage)newIcon, (int)25, (int)25);
                    this.imageLabel.setIcon(new ImageIcon(resizedDelayed));
                });
                this.imageLabel.setIcon(new ImageIcon(resized));
            }
        });
    }

    @Override
    public void toState() {
        this.comboBox.toState();
    }

    @Override
    public void fromState() {
        this.comboBox.fromState();
        this.updateImage();
    }

    public void addCallback(Runnable r) {
        this.comboBox.addCallback(r);
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

