/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.equip;

import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.plugin.osdata.clientdata.ClientDataProviderThreadProxy;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.ItemStatsProvider;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.AttackStyleSelectPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.BlowpipeDartsSelectPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.ChinchompaDistancePanel;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.DharokHpPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.EquipmentSlotPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.EquipmentTotalsPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.InWildernessCheckBox;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.OnSlayerTaskCheckBox;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.SpellSelectPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.UsingChargeCheckBox;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.UsingMarkOfDarknessCheckBox;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateVisibleComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.LoadFromClientButton;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;

@Singleton
public class EquipmentPanel
extends JPanel
implements StateBoundComponent {
    private final PanelStateManager manager;
    private final ClientDataProviderThreadProxy clientDataProviderThreadProxy;
    private final BlowpipeDartsSelectPanel blowpipeDartsSelectPanel;
    private final SpellSelectPanel spellSelectPanel;
    private final Set<StateBoundComponent> stateBoundComponents = new HashSet<StateBoundComponent>();
    private final Set<StateVisibleComponent> stateVisibleComponents = new HashSet<StateVisibleComponent>();

    @Inject
    public EquipmentPanel(@Nullable ItemManager rlItemManager, ItemStatsProvider itemStatsProvider, PanelStateManager manager, ClientDataProviderThreadProxy clientDataProviderThreadProxy, EquipmentTotalsPanel equipmentTotalsPanel, AttackStyleSelectPanel attackStyleSelectPanel, InWildernessCheckBox inWildernessCheckBox, OnSlayerTaskCheckBox onSlayerTaskCheckBox, UsingChargeCheckBox usingChargeCheckBox, UsingMarkOfDarknessCheckBox usingMarkOfDarknessCheckBox, BlowpipeDartsSelectPanel blowpipeDartsSelectPanel, DharokHpPanel dharokHpPanel, ChinchompaDistancePanel chinchompaDistancePanel, SpellSelectPanel spellSelectPanel) {
        this.manager = manager;
        this.clientDataProviderThreadProxy = clientDataProviderThreadProxy;
        this.blowpipeDartsSelectPanel = blowpipeDartsSelectPanel;
        this.spellSelectPanel = spellSelectPanel;
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(new Dimension(225, 1000));
        this.add(new LoadFromClientButton(this::loadFromClient));
        this.add(Box.createVerticalStrut(10));
        JPanel slotPanel = new JPanel();
        slotPanel.setMinimumSize(new Dimension(225, 0));
        slotPanel.setLayout(new BoxLayout(slotPanel, 1));
        slotPanel.setAlignmentX(0.5f);
        this.add(slotPanel);
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            EquipmentSlotPanel innerPanel = new EquipmentSlotPanel(manager, rlItemManager, slot, itemStatsProvider);
            innerPanel.addCallback(this::fromState);
            this.addPanel(innerPanel, slotPanel);
            slotPanel.add(Box.createVerticalStrut(5));
            if (slot == EquipmentInventorySlot.HEAD) {
                this.addPanel(onSlayerTaskCheckBox, slotPanel);
            }
            if (slot != EquipmentInventorySlot.WEAPON) continue;
            this.addPanel(inWildernessCheckBox, slotPanel);
        }
        this.add(Box.createVerticalStrut(5));
        this.addPanel(dharokHpPanel);
        dharokHpPanel.add(Box.createVerticalStrut(10));
        this.addPanel(chinchompaDistancePanel);
        chinchompaDistancePanel.add(Box.createVerticalStrut(10));
        this.addPanel(blowpipeDartsSelectPanel);
        blowpipeDartsSelectPanel.addCallback(this::fromState);
        this.addPanel(attackStyleSelectPanel);
        attackStyleSelectPanel.addCallback(this::fromState);
        this.addPanel(spellSelectPanel);
        spellSelectPanel.addCallback(this::fromState);
        this.addPanel(usingMarkOfDarknessCheckBox);
        usingMarkOfDarknessCheckBox.add(Box.createVerticalStrut(10));
        this.addPanel(usingChargeCheckBox);
        usingChargeCheckBox.add(Box.createVerticalStrut(10));
        this.addPanel(equipmentTotalsPanel);
    }

    public void loadFromClient() {
        this.clientDataProviderThreadProxy.tryAcquire(clientDataProvider -> {
            this.getState().setAttackerItems(new HashMap<EquipmentInventorySlot, ItemStats>(clientDataProvider.getPlayerEquipment()));
            this.getState().setAttackStyle(clientDataProvider.getAttackStyle().toBuilder().build());
            this.getState().setBlowpipeDarts(clientDataProvider.getBlowpipeDarts());
            this.getState().setOnSlayerTask(clientDataProvider.playerIsOnSlayerTask());
            this.getState().setUsingChargeSpell(clientDataProvider.playerIsUsingChargeSpell());
            this.getState().setUsingMarkOfDarkness(clientDataProvider.playerIsUsingMarkOfDarkness());
            this.getState().setInWilderness(clientDataProvider.playerIsInWilderness());
            this.getState().getAttackerSkills().put(Skill.HITPOINTS, clientDataProvider.getPlayerSkills().getLevels().getOrDefault(Skill.HITPOINTS, 99));
            this.getState().getAttackerBoosts().put(Skill.HITPOINTS, clientDataProvider.getPlayerSkills().getBoosts().getOrDefault(Skill.HITPOINTS, 0));
            SwingUtilities.invokeLater(this::fromState);
        });
    }

    private void addPanel(Component child) {
        this.addPanel(child, this);
    }

    private void addPanel(Component child, JPanel parent) {
        parent.add(child);
        if (child instanceof StateBoundComponent) {
            this.stateBoundComponents.add((StateBoundComponent)((Object)child));
        }
        if (child instanceof StateVisibleComponent) {
            this.stateVisibleComponents.add((StateVisibleComponent)((Object)child));
        }
    }

    @Override
    public void toState() {
        this.stateBoundComponents.forEach(StateBoundComponent::toState);
    }

    @Override
    public void fromState() {
        this.stateBoundComponents.forEach(StateBoundComponent::fromState);
        this.stateVisibleComponents.forEach(StateVisibleComponent::updateVisibility);
    }

    public boolean isReady() {
        if (this.blowpipeDartsSelectPanel.isVisible() && this.getState().getBlowpipeDarts() == null) {
            return false;
        }
        if (this.spellSelectPanel.isVisible() && this.getState().getSpell() == null) {
            return false;
        }
        return this.getState().getAttackStyle() != null;
    }

    public String getSummary() {
        if (!this.isReady()) {
            return "Not Set";
        }
        ItemStats weapon = this.getState().getAttackerItems().get(EquipmentInventorySlot.WEAPON);
        String weaponName = weapon == null ? "Unarmed" : weapon.getName();
        return this.getState().getAttackStyle().getAttackType() + " - " + weaponName;
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

