/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.equip;

import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.multihit.DharoksDptComputable;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateVisibleComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.ComputeUtil;
import com.duckblade.osrs.dpscalc.plugin.ui.util.FocusLostAdapter;
import com.duckblade.osrs.dpscalc.plugin.ui.util.JTextFieldIntOnlyKeyAdapter;
import com.duckblade.osrs.dpscalc.plugin.ui.util.SelectAllFocusListener;
import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.runelite.api.Skill;

@Singleton
public class DharokHpPanel
extends JPanel
implements StateBoundComponent,
StateVisibleComponent {
    private final PanelStateManager manager;
    private final DharoksDptComputable dharoksDptComputable;
    private final JTextField currentHpField;
    private final JTextField maxHpField;

    @Inject
    public DharokHpPanel(PanelStateManager manager, DharoksDptComputable dharoksDptComputable) {
        this.manager = manager;
        this.dharoksDptComputable = dharoksDptComputable;
        this.setMinimumSize(new Dimension(0, 70));
        this.setMaximumSize(new Dimension(225, 70));
        this.setLayout(new GridLayout(3, 2));
        this.setVisible(false);
        this.currentHpField = new JTextField("1", 3);
        this.currentHpField.setAlignmentX(0.5f);
        this.currentHpField.setHorizontalAlignment(0);
        this.currentHpField.addFocusListener(new SelectAllFocusListener(this.currentHpField));
        this.currentHpField.addKeyListener(new JTextFieldIntOnlyKeyAdapter());
        this.currentHpField.addFocusListener(new FocusLostAdapter(e -> this.toState()));
        this.currentHpField.addActionListener(e -> this.toState());
        this.maxHpField = new JTextField("99", 3);
        this.maxHpField.setAlignmentX(0.5f);
        this.maxHpField.setHorizontalAlignment(0);
        this.maxHpField.addFocusListener(new SelectAllFocusListener(this.maxHpField));
        this.maxHpField.addKeyListener(new JTextFieldIntOnlyKeyAdapter());
        this.maxHpField.addFocusListener(new FocusLostAdapter(e -> this.toState()));
        this.maxHpField.addActionListener(e -> this.toState());
        this.add(new JLabel("Curr. HP"));
        this.add(new JLabel("Max HP"));
        this.add(this.currentHpField);
        this.add(this.maxHpField);
        this.add(Box.createVerticalStrut(10));
    }

    @Override
    public void toState() {
        this.coerce();
        int currentHp = Integer.parseInt(this.currentHpField.getText());
        int maxHp = Integer.parseInt(this.maxHpField.getText());
        this.getState().getAttackerSkills().put(Skill.HITPOINTS, maxHp);
        this.getState().getAttackerBoosts().put(Skill.HITPOINTS, currentHp - maxHp);
    }

    @Override
    public void fromState() {
        int maxHp = this.getState().getAttackerSkills().getOrDefault(Skill.HITPOINTS, 99);
        int currentHp = maxHp + this.getState().getAttackerBoosts().getOrDefault(Skill.HITPOINTS, 0);
        this.currentHpField.setText(String.valueOf(currentHp));
        this.maxHpField.setText(String.valueOf(maxHp));
    }

    @Override
    public void updateVisibility() {
        ComputeUtil.computeSilent(() -> {
            ComputeContext ctx = new ComputeContext();
            ctx.put(ComputeInputs.ATTACKER_ITEMS, this.getState().getAttackerItems());
            ctx.put(ComputeInputs.ATTACK_STYLE, this.getState().getAttackStyle());
            this.setVisible(this.dharoksDptComputable.isApplicable(ctx));
        });
    }

    private void coerce() {
        if (Strings.isNullOrEmpty((String)this.currentHpField.getText())) {
            this.currentHpField.setText("1");
        }
        if (Strings.isNullOrEmpty((String)this.maxHpField.getText())) {
            this.currentHpField.setText("99");
        }
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

