/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.equip;

import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.ChinchompaDistanceGearBonus;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateVisibleComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.ComputeUtil;
import com.duckblade.osrs.dpscalc.plugin.ui.util.FocusLostAdapter;
import com.duckblade.osrs.dpscalc.plugin.ui.util.JTextFieldIntOnlyKeyAdapter;
import com.duckblade.osrs.dpscalc.plugin.ui.util.SelectAllFocusListener;
import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

@Singleton
public class ChinchompaDistancePanel
extends JPanel
implements StateBoundComponent,
StateVisibleComponent {
    private final PanelStateManager manager;
    private final ChinchompaDistanceGearBonus chinchompaDistanceGearBonus;
    private final JTextField distanceField;

    @Inject
    public ChinchompaDistancePanel(PanelStateManager manager, ChinchompaDistanceGearBonus chinchompaDistanceGearBonus) {
        this.manager = manager;
        this.chinchompaDistanceGearBonus = chinchompaDistanceGearBonus;
        this.setMinimumSize(new Dimension(205, 40));
        this.setMaximumSize(new Dimension(205, 40));
        this.setLayout(new GridLayout(2, 2));
        this.setVisible(false);
        this.distanceField = new JTextField("1", 2);
        this.distanceField.setAlignmentX(0.5f);
        this.distanceField.setHorizontalAlignment(0);
        this.distanceField.addFocusListener(new SelectAllFocusListener(this.distanceField));
        this.distanceField.addKeyListener(new JTextFieldIntOnlyKeyAdapter());
        this.distanceField.addFocusListener(new FocusLostAdapter(e -> this.toState()));
        this.distanceField.addActionListener(e -> this.toState());
        this.add(new JLabel("Distance"));
        this.add(this.distanceField);
        this.add(Box.createVerticalStrut(10));
    }

    @Override
    public void toState() {
        this.coerce();
        this.getState().setAttackerDistance(Integer.parseInt(this.distanceField.getText()));
    }

    @Override
    public void fromState() {
        this.distanceField.setText(String.valueOf(this.getState().getAttackerDistance()));
    }

    @Override
    public void updateVisibility() {
        ComputeUtil.computeSilent(() -> {
            ComputeContext ctx = new ComputeContext();
            ctx.put(ComputeInputs.ATTACKER_ITEMS, this.getState().getAttackerItems());
            ctx.put(ComputeInputs.ATTACK_STYLE, this.getState().getAttackStyle());
            this.setVisible(this.chinchompaDistanceGearBonus.isApplicable(ctx));
        });
    }

    private void coerce() {
        if (Strings.isNullOrEmpty((String)this.distanceField.getText())) {
            this.distanceField.setText("1");
        }
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

