/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui;

import com.duckblade.osrs.dpscalc.plugin.module.PluginLifecycleComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.DpsPluginPanel;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@Singleton
public class NavButtonManager
implements PluginLifecycleComponent {
    private final ClientToolbar clientToolbar;
    private final DpsPluginPanel pluginPanel;
    private NavigationButton navButton;

    @Override
    public void startUp() {
        this.navButton = NavigationButton.builder().priority(5).icon(ImageUtil.loadImageResource(this.getClass(), (String)"equip/slot_0.png")).tooltip("DPS Calculator").panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    public void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
        this.navButton = null;
    }

    public void openPanel() {
        SwingUtilities.invokeLater(() -> {
            if (!this.navButton.isSelected()) {
                this.navButton.getOnSelect().run();
            }
        });
    }

    @Inject
    public NavButtonManager(ClientToolbar clientToolbar, DpsPluginPanel pluginPanel) {
        this.clientToolbar = clientToolbar;
        this.pluginPanel = pluginPanel;
    }
}

