/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.runelite.client.plugins.config.ConfigPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class MenuPanelNavEntry
extends JPanel {
    private static final ImageIcon NAVIGATION_ICON;
    private final JLabel descriptionLabel;

    public MenuPanelNavEntry(String title, String description, final Runnable onClick) {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.setPreferredSize(new Dimension(205, 40));
        this.setMaximumSize(new Dimension(205, 40));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton navButton = new JButton(NAVIGATION_ICON);
        SwingUtil.removeButtonDecorations((AbstractButton)navButton);
        this.add((Component)navButton, "East");
        JPanel splitPanel = new JPanel();
        splitPanel.setLayout(new BoxLayout(splitPanel, 1));
        splitPanel.setOpaque(false);
        this.add((Component)splitPanel, "Center");
        JLabel titleLabel = new JLabel(title);
        titleLabel.setForeground(Color.white);
        titleLabel.setFont(FontManager.getRunescapeBoldFont());
        splitPanel.add(titleLabel);
        JSeparator separator = new JSeparator(0);
        separator.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
        splitPanel.add(separator);
        this.descriptionLabel = new JLabel(description);
        this.descriptionLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.descriptionLabel.setFont(FontManager.getRunescapeSmallFont());
        splitPanel.add(this.descriptionLabel);
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                onClick.run();
            }
        };
        titleLabel.addMouseListener(m);
        this.descriptionLabel.addMouseListener(m);
        splitPanel.addMouseListener(m);
        this.addMouseListener(m);
        navButton.addActionListener(e -> onClick.run());
    }

    public void setDescription(String text) {
        this.descriptionLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.descriptionLabel.setText(text);
    }

    static {
        BufferedImage image = ImageUtil.loadImageResource(ConfigPlugin.class, (String)"/util/arrow_right.png");
        image = ImageUtil.resizeImage((BufferedImage)image, (int)25, (int)25);
        NAVIGATION_ICON = new ImageIcon(image);
    }
}

