/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui;

import com.duckblade.osrs.dpscalc.plugin.ui.DpsCalcPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.panel.DeleteSetButton;
import com.duckblade.osrs.dpscalc.plugin.ui.state.panel.PanelInputSetSelect;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

@Singleton
public class DpsPluginPanel
extends PluginPanel {
    private final DpsCalcPanel calcPanel;
    private static final String GITHUB_LINK = "https://github.com/LlemonDuck/dps-calculator";

    @Inject
    public DpsPluginPanel(DpsCalcPanel calcPanel, PanelInputSetSelect panelInputSetSelect, DeleteSetButton deleteSetButton, PanelStateManager manager) {
        super(false);
        this.calcPanel = calcPanel;
        manager.addOnSetChangedListener(this::showHome);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setMinimumSize(new Dimension(225, 0));
        JPanel headerPanel = new JPanel();
        headerPanel.setMaximumSize(new Dimension(225, 40));
        headerPanel.setLayout(new GridBagLayout());
        this.add(headerPanel);
        ImageIcon homeIcon = new ImageIcon(ImageUtil.resizeImage((BufferedImage)ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon_home.png"), (int)25, (int)25));
        JButton homeButton = new JButton(homeIcon);
        homeButton.setFocusPainted(false);
        homeButton.setPreferredSize(new Dimension(35, 35));
        homeButton.addActionListener(e -> this.showHome());
        headerPanel.add((Component)homeButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        headerPanel.add((Component)panelInputSetSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        headerPanel.add((Component)deleteSetButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ImageIcon ghIcon = new ImageIcon(ImageUtil.resizeImage((BufferedImage)ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"gh_logo.png"), (int)25, (int)25));
        JButton linkToGh = new JButton(ghIcon);
        linkToGh.setFocusPainted(false);
        linkToGh.setPreferredSize(new Dimension(35, 35));
        linkToGh.addActionListener(e -> this.openGhLink());
        headerPanel.add((Component)linkToGh, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane contentScrollPane = new JScrollPane(calcPanel);
        contentScrollPane.setBorder(BorderFactory.createEmptyBorder());
        contentScrollPane.setHorizontalScrollBarPolicy(31);
        contentScrollPane.setVerticalScrollBarPolicy(20);
        contentScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        this.add(contentScrollPane);
    }

    private void openGhLink() {
        LinkBrowser.browse((String)GITHUB_LINK);
    }

    private void showHome() {
        SwingUtilities.invokeLater(this.calcPanel::openMenu);
    }
}

