/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui;

import com.duckblade.osrs.dpscalc.plugin.ui.MenuPanelNavEntry;
import com.duckblade.osrs.dpscalc.plugin.ui.equip.EquipmentPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.npc.NpcStatsPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.prayer.PrayerPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.result.CalcResultPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.skills.SkillsPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.LoadFromClientButton;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@Singleton
public class DpsCalcPanel
extends JPanel {
    private final JPanel menuPanel;
    private final MenuPanelNavEntry npcStatsNav;
    private final NpcStatsPanel npcStatsPanel;
    private final MenuPanelNavEntry equipmentNav;
    private final EquipmentPanel equipmentPanel;
    private final MenuPanelNavEntry skillsNav;
    private final SkillsPanel skillsPanel;
    private final MenuPanelNavEntry prayerNav;
    private final PrayerPanel prayerPanel;
    private final CalcResultPanel resultPanel;

    @Inject
    public DpsCalcPanel(NpcStatsPanel npcStatsPanel, EquipmentPanel equipmentPanel, SkillsPanel skillsPanel, PrayerPanel prayerPanel, CalcResultPanel resultPanel) {
        this.npcStatsPanel = npcStatsPanel;
        this.equipmentPanel = equipmentPanel;
        this.skillsPanel = skillsPanel;
        this.prayerPanel = prayerPanel;
        this.resultPanel = resultPanel;
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize(new Dimension(225, 0));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.menuPanel = new JPanel();
        this.menuPanel.setMinimumSize(new Dimension(225, 0));
        this.menuPanel.setLayout(new BoxLayout(this.menuPanel, 1));
        this.add(this.menuPanel);
        this.menuPanel.add(new LoadFromClientButton("Load All From Client", this::loadAllFromClient));
        this.npcStatsNav = new MenuPanelNavEntry("NPC Stats", "Not Set", () -> this.openPanel(npcStatsPanel));
        this.menuPanel.add(this.npcStatsNav);
        this.menuPanel.add(Box.createVerticalStrut(5));
        this.equipmentNav = new MenuPanelNavEntry("Equipment", "Not Set", () -> this.openPanel(equipmentPanel));
        this.menuPanel.add(this.equipmentNav);
        this.menuPanel.add(Box.createVerticalStrut(5));
        this.skillsNav = new MenuPanelNavEntry("Skills", "Not Set", () -> this.openPanel(skillsPanel));
        this.menuPanel.add(this.skillsNav);
        this.menuPanel.add(Box.createVerticalStrut(5));
        this.prayerNav = new MenuPanelNavEntry("Prayer", "None", () -> this.openPanel(prayerPanel));
        this.menuPanel.add(this.prayerNav);
        this.menuPanel.add(Box.createVerticalStrut(20));
        this.menuPanel.add(resultPanel);
    }

    private void updateResultPanel() {
        SwingUtilities.invokeLater(() -> {
            this.resultPanel.clear();
            if (this.npcStatsPanel.isReady() && this.equipmentPanel.isReady() && this.skillsPanel.isReady()) {
                this.resultPanel.fromState();
            }
        });
    }

    public void openMenu() {
        SwingUtilities.invokeLater(() -> {
            this.removeAll();
            this.add((Component)this.menuPanel, "Center");
            this.npcStatsPanel.fromState();
            this.npcStatsNav.setDescription(this.npcStatsPanel.getSummary());
            this.equipmentPanel.fromState();
            this.equipmentNav.setDescription(this.equipmentPanel.getSummary());
            this.skillsPanel.fromState();
            this.skillsNav.setDescription(this.skillsPanel.getSummary());
            this.prayerPanel.fromState();
            this.prayerNav.setDescription(this.prayerPanel.getSummary());
            this.updateResultPanel();
            this.revalidate();
            this.repaint();
        });
    }

    public void openPanel(Component c) {
        SwingUtilities.invokeLater(() -> {
            if (c instanceof StateBoundComponent) {
                ((StateBoundComponent)((Object)c)).fromState();
            }
            this.removeAll();
            this.add(c, "Center");
            this.revalidate();
            this.repaint();
        });
    }

    public void openNpcPanel() {
        this.openPanel(this.npcStatsPanel);
    }

    public void loadAllFromClient() {
        this.npcStatsPanel.loadFromClient();
        this.equipmentPanel.loadFromClient();
        this.skillsPanel.loadFromClient();
        this.prayerPanel.loadFromClient();
        this.openMenu();
    }
}

