/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.osdata.wiki;

import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcData;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcDataProvider;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.WikiDataLoader;
import com.duckblade.osrs.dpscalc.plugin.util.FutureUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WikiNpcDataProvider
implements NpcDataProvider {
    private static final Logger log = LoggerFactory.getLogger(WikiNpcDataProvider.class);
    private static final String NPC_STATS_URL = "npcs.min.json";
    private static final String NPC_BASE_IDS_URL = "npc-base-ids.min.json";
    private final Gson gson;
    private final WikiDataLoader wikiDataLoader;
    private Map<Integer, NpcData> npcStatsMap;
    private Map<Integer, Integer> npcBaseIdsMap;

    @Override
    public CompletableFuture<?> load(ExecutorService es) {
        return FutureUtil.simpleCompletableFuture(es, () -> {
            this.wikiDataLoader.getReader(NPC_BASE_IDS_URL, reader -> {
                this.npcBaseIdsMap = (Map)this.gson.fromJson(reader, new TypeToken<HashMap<Integer, Integer>>(){}.getType());
            });
            this.wikiDataLoader.getReader(NPC_STATS_URL, reader -> {
                this.npcStatsMap = (Map)this.gson.fromJson(reader, new TypeToken<HashMap<Integer, NpcData>>(){}.getType());
            });
        });
    }

    @Override
    public Set<NpcData> getAll() {
        return new HashSet<NpcData>(this.npcStatsMap.values());
    }

    @Override
    public NpcData getById(int npcId) {
        return this.npcStatsMap.get(this.canonicalize(npcId));
    }

    @Override
    public int canonicalize(int npcId) {
        return this.npcBaseIdsMap.getOrDefault(npcId, npcId);
    }

    @Inject
    public WikiNpcDataProvider(Gson gson, WikiDataLoader wikiDataLoader) {
        this.gson = gson;
        this.wikiDataLoader = wikiDataLoader;
    }
}

