/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.osdata.wiki;

import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.ItemStatsProvider;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.WikiDataLoader;
import com.duckblade.osrs.dpscalc.plugin.util.FutureUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WikiItemStatsProvider
implements ItemStatsProvider {
    private static final Logger log = LoggerFactory.getLogger(WikiItemStatsProvider.class);
    private static final String ITEM_STATS_URL = "items.min.json";
    private Map<Integer, ItemStats> itemStatsMap;
    private final Gson gson;
    private final WikiDataLoader wikiDataLoader;

    @Override
    public CompletableFuture<?> load(ExecutorService es) {
        return FutureUtil.simpleCompletableFuture(es, () -> this.wikiDataLoader.getReader(ITEM_STATS_URL, reader -> {
            this.itemStatsMap = (Map)this.gson.fromJson(reader, new TypeToken<HashMap<Integer, ItemStats>>(){}.getType());
        }));
    }

    @Override
    public Set<ItemStats> getAll() {
        return new HashSet<ItemStats>(this.itemStatsMap.values());
    }

    @Override
    public ItemStats getById(int npcId) {
        return this.itemStatsMap.get(npcId);
    }

    @Inject
    public WikiItemStatsProvider(Gson gson, WikiDataLoader wikiDataLoader) {
        this.gson = gson;
        this.wikiDataLoader = wikiDataLoader;
    }
}

