/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.osdata.clientdata;

import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.DefenderAttributes;
import com.duckblade.osrs.dpscalc.calc.model.DefensiveBonuses;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.calc.model.Prayer;
import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.calc.model.Spell;
import com.duckblade.osrs.dpscalc.plugin.config.DpsCalcConfig;
import com.duckblade.osrs.dpscalc.plugin.osdata.clientdata.ClientDataProvider;
import com.duckblade.osrs.dpscalc.plugin.osdata.clientdata.InteractingNpcTracker;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.ItemStatsProvider;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcData;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcDataProvider;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Skill;
import net.runelite.client.plugins.slayer.SlayerPluginService;

@Singleton
public class RuneLiteClientDataProvider
implements ClientDataProvider {
    private static final int AUTOCAST_SPELL_VARBIT = 276;
    private final Client client;
    private final SlayerPluginService slayerPluginService;
    private final DpsCalcConfig config;
    private final ItemStatsProvider itemStatsProvider;
    private final NpcDataProvider npcDataProvider;
    private final InteractingNpcTracker interactingNpcTracker;

    @Override
    public Skills getPlayerSkills() {
        EnumMap<Skill, Integer> levels = new EnumMap<Skill, Integer>(Skill.class);
        EnumMap<Skill, Integer> boosts = new EnumMap<Skill, Integer>(Skill.class);
        for (Skill s : Skill.values()) {
            if (s == Skill.OVERALL) continue;
            int level = this.client.getRealSkillLevel(s);
            levels.put(s, level);
            boosts.put(s, this.client.getBoostedSkillLevel(s) - level);
        }
        return Skills.builder().levels((Map<? extends Skill, ? extends Integer>)ImmutableMap.copyOf(levels)).boosts((Map<? extends Skill, ? extends Integer>)ImmutableMap.copyOf(boosts)).build();
    }

    @Override
    public Map<EquipmentInventorySlot, ItemStats> getPlayerEquipment() {
        ItemContainer inv = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (inv == null) {
            return Collections.emptyMap();
        }
        EnumMap<EquipmentInventorySlot, ItemStats> equipment = new EnumMap<EquipmentInventorySlot, ItemStats>(EquipmentInventorySlot.class);
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            ItemStats is;
            Item i = inv.getItem(slot.getSlotIdx());
            ItemStats itemStats = is = i == null ? null : this.itemStatsProvider.getById(i.getId());
            if (is == null) continue;
            equipment.put(slot, is);
        }
        return ImmutableMap.copyOf(equipment);
    }

    @Override
    public Set<Prayer> getPlayerActivePrayers() {
        EnumSet<Prayer> prayers = EnumSet.noneOf(Prayer.class);
        for (Prayer p : Prayer.values()) {
            if (!this.client.isPrayerActive(p.getRlPrayer())) continue;
            prayers.add(p);
        }
        return ImmutableSet.copyOf(prayers);
    }

    @Override
    public AttackStyle getAttackStyle() {
        ItemStats weapon = this.getPlayerEquipment().getOrDefault(EquipmentInventorySlot.WEAPON, ItemStats.EMPTY);
        int asVarp = this.client.getVarpValue(43);
        for (AttackStyle as : weapon.getWeaponCategory().getAttackStyles()) {
            if (as.getVarpValue() != asVarp) continue;
            return as;
        }
        return null;
    }

    @Override
    public Spell getSpell() {
        int spellVarb = this.client.getVarbitValue(276);
        for (Spell s : Spell.values()) {
            if (s.getVarbValue() != spellVarb) continue;
            return s;
        }
        return null;
    }

    @Override
    public ItemStats getBlowpipeDarts() {
        return this.itemStatsProvider.getById(this.config.defaultBlowpipeDarts().getItemId());
    }

    @Override
    public Skills getNpcTargetSkills() {
        NpcData lastInteracted = this.interactingNpcTracker.getLastInteracted();
        return lastInteracted == null ? null : lastInteracted.getSkills();
    }

    @Override
    public DefensiveBonuses getNpcTargetBonuses() {
        NpcData lastInteracted = this.interactingNpcTracker.getLastInteracted();
        return lastInteracted == null ? null : lastInteracted.getDefensiveBonuses();
    }

    @Override
    public DefenderAttributes getNpcTargetAttributes() {
        NpcData lastInteracted = this.interactingNpcTracker.getLastInteracted();
        return lastInteracted == null ? null : lastInteracted.getAttributes();
    }

    @Override
    public boolean playerIsOnSlayerTask() {
        DefenderAttributes attr = this.getNpcTargetAttributes();
        if (attr == null) {
            return false;
        }
        List targets = this.slayerPluginService.getTargets();
        if (targets == null) {
            return false;
        }
        return targets.stream().anyMatch(npc -> this.npcDataProvider.canonicalize(npc.getId()) == attr.getNpcId());
    }

    @Override
    public boolean playerIsUsingChargeSpell() {
        return false;
    }

    @Override
    public boolean playerIsUsingMarkOfDarkness() {
        return false;
    }

    @Override
    public boolean playerIsInWilderness() {
        return this.client.getVarbitValue(8121) == 1;
    }

    @Inject
    public RuneLiteClientDataProvider(Client client, SlayerPluginService slayerPluginService, DpsCalcConfig config, ItemStatsProvider itemStatsProvider, NpcDataProvider npcDataProvider, InteractingNpcTracker interactingNpcTracker) {
        this.client = client;
        this.slayerPluginService = slayerPluginService;
        this.config = config;
        this.itemStatsProvider = itemStatsProvider;
        this.npcDataProvider = npcDataProvider;
        this.interactingNpcTracker = interactingNpcTracker;
    }
}

