/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.osdata.clientdata;

import com.duckblade.osrs.dpscalc.plugin.module.PluginLifecycleComponent;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcData;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcDataProvider;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.InteractingChanged;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InteractingNpcTracker
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(InteractingNpcTracker.class);
    private final EventBus eventBus;
    private final Client client;
    private final NpcDataProvider npcDataProvider;
    private NpcData lastInteracted = null;
    private int lastInteractedIndex = -1;

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged e) {
        if (e.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        if (!(e.getTarget() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)e.getTarget();
        this.lastInteractedIndex = npc.getIndex();
        this.lastInteracted = this.npcDataProvider.getById(npc.getId());
        log.debug("Setting last interacted to {}", (Object)(this.lastInteracted == null ? "null" : this.lastInteracted.getAttributes().getName()));
    }

    @Inject
    public InteractingNpcTracker(EventBus eventBus, Client client, NpcDataProvider npcDataProvider) {
        this.eventBus = eventBus;
        this.client = client;
        this.npcDataProvider = npcDataProvider;
    }

    public NpcData getLastInteracted() {
        return this.lastInteracted;
    }

    public int getLastInteractedIndex() {
        return this.lastInteractedIndex;
    }
}

