/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.osdata.clientdata;

import com.duckblade.osrs.dpscalc.plugin.osdata.clientdata.ClientDataProvider;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;

@Singleton
public class ClientDataProviderThreadProxy {
    private final Client client;
    private final ClientThread clientThread;
    private final ClientDataProvider clientDataProvider;

    public void tryAcquire(Consumer<ClientDataProvider> runnable) {
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null) {
                runnable.accept(this.clientDataProvider);
            }
        });
    }

    @Inject
    public ClientDataProviderThreadProxy(Client client, ClientThread clientThread, ClientDataProvider clientDataProvider) {
        this.client = client;
        this.clientThread = clientThread;
        this.clientDataProvider = clientDataProvider;
    }
}

