/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.osdata.clientdata;

import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.ComputeInput;
import com.duckblade.osrs.dpscalc.calc.model.DefenderAttributes;
import com.duckblade.osrs.dpscalc.calc.model.DefensiveBonuses;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.calc.model.Prayer;
import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.calc.model.Spell;
import java.util.Map;
import java.util.Set;
import net.runelite.api.EquipmentInventorySlot;

public interface ClientDataProvider {
    public Skills getPlayerSkills();

    public Map<EquipmentInventorySlot, ItemStats> getPlayerEquipment();

    public Set<Prayer> getPlayerActivePrayers();

    public AttackStyle getAttackStyle();

    public Spell getSpell();

    public ItemStats getBlowpipeDarts();

    public Skills getNpcTargetSkills();

    public DefensiveBonuses getNpcTargetBonuses();

    public DefenderAttributes getNpcTargetAttributes();

    public boolean playerIsOnSlayerTask();

    public boolean playerIsUsingChargeSpell();

    public boolean playerIsUsingMarkOfDarkness();

    public boolean playerIsInWilderness();

    default public ComputeInput toComputeInput() {
        return ComputeInput.builder().attackerSkills(this.getPlayerSkills()).attackerItems(this.getPlayerEquipment()).attackerPrayers(this.getPlayerActivePrayers()).attackStyle(this.getAttackStyle()).spell(this.getSpell()).blowpipeDarts(this.getBlowpipeDarts()).defenderSkills(this.getNpcTargetSkills()).defenderBonuses(this.getNpcTargetBonuses()).defenderAttributes(this.getNpcTargetAttributes()).onSlayerTask(this.playerIsOnSlayerTask()).usingChargeSpell(this.playerIsUsingChargeSpell()).usingMarkOfDarkness(this.playerIsUsingMarkOfDarkness()).inWilderness(this.playerIsInWilderness()).build();
    }
}

