/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.module;

import com.duckblade.osrs.dpscalc.plugin.config.DpsCalcConfig;
import com.duckblade.osrs.dpscalc.plugin.module.PluginLifecycleComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ComponentManager {
    private static final Logger log = LoggerFactory.getLogger(ComponentManager.class);
    private final EventBus eventBus;
    private final DpsCalcConfig config;
    private final Set<PluginLifecycleComponent> components;
    private final Map<PluginLifecycleComponent, Boolean> states = new HashMap<PluginLifecycleComponent, Boolean>();

    public void onPluginStart() {
        this.eventBus.register((Object)this);
        this.components.forEach(c -> this.states.put((PluginLifecycleComponent)c, false));
        this.components.stream().filter(c -> c.isConfigEnabled().test(this.config)).forEach(this::tryStartUp);
    }

    public void onPluginStop() {
        this.eventBus.unregister((Object)this);
        this.components.stream().filter(this.states::get).forEach(this::tryShutDown);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!"dpscalculator".equals(e.getGroup())) {
            return;
        }
        this.components.forEach(c -> {
            boolean isEnabled;
            boolean shouldBeEnabled = c.isConfigEnabled().test(this.config);
            if (shouldBeEnabled == (isEnabled = this.states.get(c).booleanValue())) {
                return;
            }
            if (shouldBeEnabled) {
                this.tryStartUp((PluginLifecycleComponent)c);
            } else {
                this.tryShutDown((PluginLifecycleComponent)c);
            }
        });
    }

    private void tryStartUp(PluginLifecycleComponent component) {
        if (this.states.get(component).booleanValue()) {
            return;
        }
        try {
            component.startUp();
            this.states.put(component, true);
        }
        catch (Exception e) {
            log.error("Failed to start DPS Calc component [{}]", (Object)component.getClass().getName(), (Object)e);
        }
    }

    private void tryShutDown(PluginLifecycleComponent component) {
        if (!this.states.get(component).booleanValue()) {
            return;
        }
        try {
            component.shutDown();
        }
        catch (Exception e) {
            log.error("Failed to cleanly shut down DPS Calc component [{}]", (Object)component.getClass().getName());
        }
        finally {
            this.states.put(component, false);
        }
    }

    @Inject
    public ComponentManager(EventBus eventBus, DpsCalcConfig config, Set<PluginLifecycleComponent> components) {
        this.eventBus = eventBus;
        this.config = config;
        this.components = components;
    }
}

