/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.live.party;

import com.duckblade.osrs.dpscalc.plugin.config.DpsCalcConfig;
import com.duckblade.osrs.dpscalc.plugin.live.TargetedDps;
import com.duckblade.osrs.dpscalc.plugin.live.TargetedDpsChanged;
import com.duckblade.osrs.dpscalc.plugin.live.party.messages.UpdateLiveDps;
import com.duckblade.osrs.dpscalc.plugin.module.PluginLifecycleComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.events.UserPart;
import net.runelite.client.party.messages.PartyMessage;

@Singleton
public class PartyDpsService
implements PluginLifecycleComponent {
    private final EventBus eventBus;
    private final PartyService partyService;
    private final WSClient wsClient;
    private final Map<Long, TargetedDps> partyMemberDps = new HashMap<Long, TargetedDps>();

    @Override
    public Predicate<DpsCalcConfig> isConfigEnabled() {
        return DpsCalcConfig::enablePartyService;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.wsClient.registerMessage(UpdateLiveDps.class);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.wsClient.unregisterMessage(UpdateLiveDps.class);
    }

    @Subscribe
    public void onPartyChanged(PartyChanged e) {
        this.partyMemberDps.clear();
    }

    @Subscribe
    public void onUserPart(UserPart e) {
        this.partyMemberDps.remove(e.getMemberId());
    }

    @Subscribe
    public void onUpdateLiveDps(UpdateLiveDps e) {
        this.setMemberDps(e.getMemberId(), e.getTargetedDps());
    }

    @Subscribe
    public void onTargetedDpsChanged(TargetedDpsChanged e) {
        PartyMember localMember;
        if (this.partyService.isInParty() && (localMember = this.partyService.getLocalMember()) != null) {
            long localId = localMember.getMemberId();
            this.setMemberDps(localId, e.getTargetedDps());
            this.partyService.send((PartyMessage)new UpdateLiveDps(localId, e.getTargetedDps()));
        }
    }

    private void setMemberDps(long memberId, TargetedDps dps) {
        if (dps == null) {
            this.partyMemberDps.remove(memberId);
        } else {
            this.partyMemberDps.put(memberId, dps);
        }
    }

    public double getPartyDps(int npcIndex) {
        return this.partyMemberDps.values().stream().filter(td -> td.getNpcIndex() == npcIndex).mapToDouble(TargetedDps::getDps).sum();
    }

    public boolean hasDps() {
        return this.partyService.isInParty() && !this.partyMemberDps.isEmpty();
    }

    @Inject
    public PartyDpsService(EventBus eventBus, PartyService partyService, WSClient wsClient) {
        this.eventBus = eventBus;
        this.partyService = partyService;
        this.wsClient = wsClient;
    }
}

