/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.live.overlay;

import com.duckblade.osrs.dpscalc.plugin.config.DpsCalcConfig;
import com.duckblade.osrs.dpscalc.plugin.module.PluginLifecycleComponent;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.util.HotkeyListener;

@Singleton
public class OverlayMinimizerService
implements PluginLifecycleComponent {
    private final EventBus eventBus;
    private final KeyManager keyManager;
    private final DpsCalcConfig config;
    private HotkeyListener toggleListener;
    private boolean forceMinimized = false;
    private Instant minimizeTimeout = Instant.now();
    private boolean timeoutMinimized = false;

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.toggleListener = new HotkeyListener(this.config::liveOverlayMinimizeHotkey){

            public void hotkeyPressed() {
                OverlayMinimizerService.this.forceMinimized = !OverlayMinimizerService.this.forceMinimized;
            }
        };
        this.keyManager.registerKeyListener((KeyListener)this.toggleListener);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.keyManager.unregisterKeyListener((KeyListener)this.toggleListener);
    }

    public boolean isMinimized() {
        if (!this.timeoutMinimized) {
            this.timeoutMinimized = this.minimizeTimeout.isBefore(Instant.now());
        }
        return this.forceMinimized || this.timeoutMinimized;
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied e) {
        if (e.getHitsplat().isMine()) {
            this.timeoutMinimized = false;
            this.minimizeTimeout = Instant.now().plus((long)this.config.liveOverlayMinimizeDelay(), ChronoUnit.SECONDS);
        }
    }

    @Inject
    public OverlayMinimizerService(EventBus eventBus, KeyManager keyManager, DpsCalcConfig config) {
        this.eventBus = eventBus;
        this.keyManager = keyManager;
        this.config = config;
    }
}

