/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.live.overlay;

import com.duckblade.osrs.dpscalc.calc.HitChanceComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.maxhit.TrueMaxHitComputable;
import com.duckblade.osrs.dpscalc.plugin.config.DpsCalcConfig;
import com.duckblade.osrs.dpscalc.plugin.live.TargetedDps;
import com.duckblade.osrs.dpscalc.plugin.live.TargetedDpsChanged;
import com.duckblade.osrs.dpscalc.plugin.live.overlay.OverlayMinimizerService;
import com.duckblade.osrs.dpscalc.plugin.live.party.PartyDpsService;
import com.duckblade.osrs.dpscalc.plugin.module.PluginLifecycleComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.ComputeUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LiveDpsOverlay
extends OverlayPanel
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(LiveDpsOverlay.class);
    private static final DecimalFormat DPS_FORMAT = new DecimalFormat("#.##");
    private static final DecimalFormat MAX_HIT_FORMAT = new DecimalFormat("#.##");
    private static final DecimalFormat HIT_CHANCE_FORMAT = new DecimalFormat("#.##%");
    private final EventBus eventBus;
    private final OverlayManager overlayManager;
    private final DpsCalcConfig config;
    private final OverlayMinimizerService overlayMinimizerService;
    private final PartyDpsService partyDpsService;
    private final TrueMaxHitComputable trueMaxHitComputable;
    private final HitChanceComputable hitChanceComputable;
    private TargetedDps targetedDps;
    private Integer maxHit;
    private Double hitChance;

    @Inject
    public LiveDpsOverlay(OverlayManager overlayManager, EventBus eventBus, DpsCalcConfig config, OverlayMinimizerService overlayMinimizerService, PartyDpsService partyDpsService, TrueMaxHitComputable trueMaxHitComputable, HitChanceComputable hitChanceComputable) {
        this.eventBus = eventBus;
        this.overlayManager = overlayManager;
        this.config = config;
        this.overlayMinimizerService = overlayMinimizerService;
        this.partyDpsService = partyDpsService;
        this.trueMaxHitComputable = trueMaxHitComputable;
        this.hitChanceComputable = hitChanceComputable;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
    }

    @Override
    public Predicate<DpsCalcConfig> isConfigEnabled() {
        return DpsCalcConfig::showLiveOverlay;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.overlayManager.add((Overlay)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.overlayManager.remove((Overlay)this);
    }

    @Subscribe
    public void onTargetedDpsChanged(TargetedDpsChanged e) {
        this.targetedDps = e.getTargetedDps();
        ComputeContext context = e.getContext();
        this.maxHit = ComputeUtil.tryCompute(() -> context.get(this.trueMaxHitComputable));
        this.hitChance = ComputeUtil.tryCompute(() -> context.get(this.hitChanceComputable));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.overlayMinimizerService.isMinimized()) {
            return null;
        }
        if (this.targetedDps == null && this.config.liveOverlayMinimizeIncomplete()) {
            return null;
        }
        if (this.config.liveOverlayShowTitle()) {
            this.getPanelComponent().getChildren().add(TitleComponent.builder().text("DPS Calc").build());
        }
        if (this.config.liveOverlayShowDps()) {
            this.addLineComponent("DPS", this.targetedDps == null ? "???" : DPS_FORMAT.format(this.targetedDps.getDps()));
        }
        if (this.config.liveOverlayShowPartyDps() && this.partyDpsService.hasDps()) {
            double partyDps = this.partyDpsService.getPartyDps(this.targetedDps.getNpcIndex());
            this.addLineComponent("Party DPS", this.targetedDps == null ? "???" : DPS_FORMAT.format(partyDps));
        }
        if (this.config.liveOverlayShowMaxHit()) {
            this.addLineComponent("Max Hit", this.maxHit == null ? "???" : MAX_HIT_FORMAT.format(this.maxHit));
        }
        if (this.config.liveOverlayShowHitChance()) {
            this.addLineComponent("Hit Chance", this.hitChance == null ? "???" : HIT_CHANCE_FORMAT.format(this.hitChance));
        }
        return super.render(graphics);
    }

    private void addLineComponent(String left, String right) {
        this.getPanelComponent().getChildren().add(LineComponent.builder().left(left).right(right).build());
    }
}

