/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.live;

import com.duckblade.osrs.dpscalc.calc.DpsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.exceptions.MissingInputException;
import com.duckblade.osrs.dpscalc.calc.model.ComputeInput;
import com.duckblade.osrs.dpscalc.calc.model.DefenderAttributes;
import com.duckblade.osrs.dpscalc.plugin.live.TargetedDps;
import com.duckblade.osrs.dpscalc.plugin.live.TargetedDpsChanged;
import com.duckblade.osrs.dpscalc.plugin.module.PluginLifecycleComponent;
import com.duckblade.osrs.dpscalc.plugin.osdata.clientdata.ClientDataProvider;
import com.duckblade.osrs.dpscalc.plugin.osdata.clientdata.InteractingNpcTracker;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class LiveDpsService
implements PluginLifecycleComponent {
    private final EventBus eventBus;
    private final ClientDataProvider clientDataProvider;
    private final DpsComputable dpsComputable;
    private final InteractingNpcTracker interactingNpcTracker;
    private ComputeInput lastInput;
    private int lastNpcIndex;

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        block5: {
            ComputeInput input = this.clientDataProvider.toComputeInput();
            int npcIndex = this.interactingNpcTracker.getLastInteractedIndex();
            if (!input.equals(this.lastInput) || this.lastNpcIndex != npcIndex) {
                this.lastNpcIndex = npcIndex;
                this.lastInput = input;
                ComputeContext context = new ComputeContext(input);
                try {
                    DefenderAttributes defenderAttributes = input.getDefenderAttributes();
                    if (defenderAttributes == null || defenderAttributes.getNpcId() == -1) {
                        this.setDps(null, input, context);
                    } else {
                        TargetedDps newDps = new TargetedDps(npcIndex, context.get(this.dpsComputable));
                        this.setDps(newDps, input, context);
                    }
                }
                catch (Exception e) {
                    this.setDps(null, input, context);
                    if (e.getCause() instanceof MissingInputException) break block5;
                    throw e;
                }
            }
        }
    }

    public void setDps(TargetedDps newValue, ComputeInput input, ComputeContext context) {
        this.eventBus.post((Object)new TargetedDpsChanged(newValue, input, context));
    }

    @Inject
    public LiveDpsService(EventBus eventBus, ClientDataProvider clientDataProvider, DpsComputable dpsComputable, InteractingNpcTracker interactingNpcTracker) {
        this.eventBus = eventBus;
        this.clientDataProvider = clientDataProvider;
        this.dpsComputable = dpsComputable;
        this.interactingNpcTracker = interactingNpcTracker;
    }
}

