/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin;

import com.duckblade.osrs.dpscalc.plugin.config.DpsCalcConfig;
import com.duckblade.osrs.dpscalc.plugin.module.PluginLifecycleComponent;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcData;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcDataProvider;
import com.duckblade.osrs.dpscalc.plugin.ui.DpsCalcPanel;
import com.duckblade.osrs.dpscalc.plugin.ui.NavButtonManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelState;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.NPC;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class DpsMenuActionListener
implements PluginLifecycleComponent {
    private final EventBus eventBus;
    private final Client client;
    private final NpcDataProvider npcDataProvider;
    private final NavButtonManager navButtonManager;
    private final PanelStateManager panelStateManager;
    private final DpsCalcPanel dpsCalcPanel;

    @Override
    public Predicate<DpsCalcConfig> isConfigEnabled() {
        return DpsCalcConfig::showMinimenuEntry;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded e) {
        NPC npc;
        int npcId;
        NpcData npcData;
        if (MenuAction.of((int)e.getType()) == MenuAction.EXAMINE_NPC && (npcData = this.npcDataProvider.getById(npcId = (npc = this.client.getCachedNPCs()[e.getIdentifier()]).getId())) != null) {
            this.client.createMenuEntry(-1).setOption("Dps").setTarget(e.getTarget()).setType(MenuAction.RUNELITE).setParam0(e.getActionParam0()).setParam1(e.getActionParam1()).setIdentifier(e.getIdentifier()).onClick(me -> this.onMenuOptionClicked(npcData));
        }
    }

    public void onMenuOptionClicked(NpcData npcData) {
        SwingUtilities.invokeLater(() -> {
            PanelState panelState = this.panelStateManager.currentState();
            panelState.loadNpcData(npcData);
            this.dpsCalcPanel.openNpcPanel();
            this.navButtonManager.openPanel();
        });
    }

    @Inject
    public DpsMenuActionListener(EventBus eventBus, Client client, NpcDataProvider npcDataProvider, NavButtonManager navButtonManager, PanelStateManager panelStateManager, DpsCalcPanel dpsCalcPanel) {
        this.eventBus = eventBus;
        this.client = client;
        this.npcDataProvider = npcDataProvider;
        this.navButtonManager = navButtonManager;
        this.panelStateManager = panelStateManager;
        this.dpsCalcPanel = dpsCalcPanel;
    }
}

