/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin;

import com.duckblade.osrs.dpscalc.calc.DpsComputeModule;
import com.duckblade.osrs.dpscalc.plugin.config.DpsCalcConfig;
import com.duckblade.osrs.dpscalc.plugin.module.ComponentManager;
import com.duckblade.osrs.dpscalc.plugin.module.DpsPluginModule;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.ItemStatsProvider;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcDataProvider;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.slayer.SlayerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@PluginDependency(value=SlayerPlugin.class)
@PluginDescriptor(name="DPS Calculator")
public class DpsCalcPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DpsCalcPlugin.class);
    private static final ListeningExecutorService dataLoadEs = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
    private ComponentManager componentManager;

    public void configure(Binder binder) {
        binder.install((Module)new DpsComputeModule());
        binder.install((Module)new DpsPluginModule());
    }

    protected void startUp() {
        CompletableFuture.allOf(((NpcDataProvider)this.injector.getInstance(NpcDataProvider.class)).load((ExecutorService)dataLoadEs), ((ItemStatsProvider)this.injector.getInstance(ItemStatsProvider.class)).load((ExecutorService)dataLoadEs)).thenRunAsync(() -> SwingUtilities.invokeLater(() -> {
            this.componentManager = (ComponentManager)this.injector.getInstance(ComponentManager.class);
            this.componentManager.onPluginStart();
        }), (Executor)dataLoadEs);
    }

    protected void shutDown() {
        this.componentManager.onPluginStop();
    }

    @Provides
    DpsCalcConfig provideConfig(ConfigManager configManager) {
        return (DpsCalcConfig)configManager.getConfig(DpsCalcConfig.class);
    }
}

