/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.prayer;

import com.duckblade.osrs.dpscalc.calc.AttackerItemStatsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.prayer.PrayerDrainComputable;
import com.duckblade.osrs.dpscalc.calc.util.TicksToDurationComputable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Skill;

@Singleton
public class PrayerDurationRemainingComputable
extends TicksToDurationComputable {
    private final AttackerItemStatsComputable attackerItemStatsComputable;
    private final PrayerDrainComputable prayerDrainComputable;

    @Override
    public int getTicks(ComputeContext context) {
        int drain = context.get(this.prayerDrainComputable);
        if (drain == 0) {
            return -1;
        }
        int points = context.get(ComputeInputs.ATTACKER_SKILLS).getTotals().get(Skill.PRAYER);
        int resistance = 2 * context.get(this.attackerItemStatsComputable).getPrayer() + 60;
        int buffer = points * resistance;
        return (int)Math.ceil((double)buffer / (double)drain);
    }

    @Inject
    public PrayerDurationRemainingComputable(AttackerItemStatsComputable attackerItemStatsComputable, PrayerDrainComputable prayerDrainComputable) {
        this.attackerItemStatsComputable = attackerItemStatsComputable;
        this.prayerDrainComputable = prayerDrainComputable;
    }
}

