/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.multihit;

import com.duckblade.osrs.dpscalc.calc.AttackSpeedComputable;
import com.duckblade.osrs.dpscalc.calc.BaseHitDptComputable;
import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.maxhit.BaseMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.multihit.MultiHitDptComputable;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class VeracsDptComputable
implements MultiHitDptComputable {
    private static final Set<Integer> VERACS_FLAIL_IDS = ImmutableSet.of((Object)4755, (Object)4982, (Object)4983, (Object)4984, (Object)4985);
    private static final Set<Integer> VERACS_HELM_IDS = ImmutableSet.of((Object)4753, (Object)4976, (Object)4977, (Object)4978, (Object)4979);
    private static final Set<Integer> VERACS_BRASSARD_IDS = ImmutableSet.of((Object)4757, (Object)4988, (Object)4989, (Object)4990, (Object)4991);
    private static final Set<Integer> VERACS_PLATESKIRT_IDS = ImmutableSet.of((Object)4759, (Object)4994, (Object)4995, (Object)4996, (Object)4997);
    private final BaseHitDptComputable baseHitDptComputable;
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;
    private final BaseMaxHitComputable baseMaxHitComputable;
    private final AttackSpeedComputable attackSpeedComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        if (!context.get(ComputeInputs.ATTACK_STYLE).getAttackType().isMelee()) {
            return false;
        }
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        return VERACS_FLAIL_IDS.contains(equipment.get(EquipmentInventorySlot.WEAPON)) && VERACS_HELM_IDS.contains(equipment.get(EquipmentInventorySlot.HEAD)) && VERACS_BRASSARD_IDS.contains(equipment.get(EquipmentInventorySlot.BODY)) && VERACS_PLATESKIRT_IDS.contains(equipment.get(EquipmentInventorySlot.LEGS));
    }

    @Override
    public Double compute(ComputeContext context) {
        double baseDps = context.get(this.baseHitDptComputable);
        int maxHit = context.get(this.baseMaxHitComputable);
        int attackSpeed = context.get(this.attackSpeedComputable);
        double specialDps = BaseHitDptComputable.byComponents(1.0, maxHit + 2, attackSpeed);
        return 0.75 * baseDps + 0.25 * specialDps;
    }

    @Inject
    public VeracsDptComputable(BaseHitDptComputable baseHitDptComputable, EquipmentItemIdsComputable equipmentItemIdsComputable, BaseMaxHitComputable baseMaxHitComputable, AttackSpeedComputable attackSpeedComputable) {
        this.baseHitDptComputable = baseHitDptComputable;
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
        this.baseMaxHitComputable = baseMaxHitComputable;
        this.attackSpeedComputable = attackSpeedComputable;
    }
}

