/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.multihit;

import com.duckblade.osrs.dpscalc.calc.AttackSpeedComputable;
import com.duckblade.osrs.dpscalc.calc.BaseHitDptComputable;
import com.duckblade.osrs.dpscalc.calc.HitChanceComputable;
import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeOutput;
import com.duckblade.osrs.dpscalc.calc.maxhit.BaseMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.PreLimitBaseMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.limiters.MaxHitLimitComputable;
import com.duckblade.osrs.dpscalc.calc.multihit.MultiHitDptComputable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScytheDptComputable
implements MultiHitDptComputable {
    public static final ComputeOutput<Integer> SCY_MAX_HIT_2 = ComputeOutput.of("MaxHit-Scy2");
    public static final ComputeOutput<Integer> SCY_MAX_HIT_3 = ComputeOutput.of("MaxHit-Scy3");
    public static final ComputeOutput<Integer> SCY_MAX_HIT_SUM = ComputeOutput.of("MaxHit-ScySum");
    private static final Set<Integer> SCYTHE_IDS = ImmutableSet.of((Object)22325, (Object)22486, (Object)22664, (Object)25736, (Object)25738, (Object)25739, (Object[])new Integer[]{25741});
    private final WeaponComputable weaponComputable;
    private final BaseHitDptComputable baseHitDptComputable;
    private final HitChanceComputable hitChanceComputable;
    private final PreLimitBaseMaxHitComputable preLimitBaseMaxHitComputable;
    private final BaseMaxHitComputable baseMaxHitComputable;
    private final MaxHitLimitComputable maxHitLimitComputable;
    private final AttackSpeedComputable attackSpeedComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return context.get(ComputeInputs.ATTACK_STYLE).getAttackType().isMelee() && SCYTHE_IDS.contains(context.get(this.weaponComputable).getItemId());
    }

    @Override
    public Double compute(ComputeContext context) {
        double baseDps = context.get(this.baseHitDptComputable);
        int npcSize = context.get(ComputeInputs.DEFENDER_ATTRIBUTES).getSize();
        if (npcSize < 2) {
            context.warn("Using the Scythe of vitur against size 1 targets is inefficient unless hitting multiple enemies.");
            return baseDps;
        }
        double hitChance = context.get(this.hitChanceComputable);
        int attackSpeed = context.get(this.attackSpeedComputable);
        int maxHitUnlimited = context.get(this.preLimitBaseMaxHitComputable);
        int maxHit1 = context.get(this.baseMaxHitComputable);
        int maxHit2 = this.maxHitLimitComputable.coerce(maxHitUnlimited / 2, context);
        context.put(SCY_MAX_HIT_2, maxHit2);
        double secondHitDps = BaseHitDptComputable.byComponents(hitChance, maxHit2, attackSpeed);
        double thirdHitDps = 0.0;
        int maxHit3 = 0;
        if (npcSize > 2) {
            maxHit3 = this.maxHitLimitComputable.coerce(maxHitUnlimited / 4, context);
            context.put(SCY_MAX_HIT_3, maxHit3);
            thirdHitDps = BaseHitDptComputable.byComponents(hitChance, maxHit3, attackSpeed);
        }
        context.put(SCY_MAX_HIT_SUM, maxHit1 + maxHit2 + maxHit3);
        return baseDps + secondHitDps + thirdHitDps;
    }

    @Inject
    public ScytheDptComputable(WeaponComputable weaponComputable, BaseHitDptComputable baseHitDptComputable, HitChanceComputable hitChanceComputable, PreLimitBaseMaxHitComputable preLimitBaseMaxHitComputable, BaseMaxHitComputable baseMaxHitComputable, MaxHitLimitComputable maxHitLimitComputable, AttackSpeedComputable attackSpeedComputable) {
        this.weaponComputable = weaponComputable;
        this.baseHitDptComputable = baseHitDptComputable;
        this.hitChanceComputable = hitChanceComputable;
        this.preLimitBaseMaxHitComputable = preLimitBaseMaxHitComputable;
        this.baseMaxHitComputable = baseMaxHitComputable;
        this.maxHitLimitComputable = maxHitLimitComputable;
        this.attackSpeedComputable = attackSpeedComputable;
    }
}

