/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.multihit;

import com.duckblade.osrs.dpscalc.calc.AttackSpeedComputable;
import com.duckblade.osrs.dpscalc.calc.BaseHitDptComputable;
import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.HitChanceComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.maxhit.BaseMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.limiters.MaxHitLimitComputable;
import com.duckblade.osrs.dpscalc.calc.multihit.MultiHitDptComputable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class OsmumtensFangDptComputable
implements MultiHitDptComputable {
    private static final Set<Integer> FANG_IDS = ImmutableSet.of((Object)26219, (Object)27246);
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;
    private final BaseMaxHitComputable baseMaxHitComputable;
    private final HitChanceComputable hitChanceComputable;
    private final AttackSpeedComputable attackSpeedComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return context.get(ComputeInputs.ATTACK_STYLE).getAttackType().isMelee() && FANG_IDS.contains(context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.WEAPON));
    }

    @Override
    public Double compute(ComputeContext context) {
        double baseHitChance = context.get(this.hitChanceComputable);
        double effectHitChance = 1.0 - Math.pow(1.0 - baseHitChance, 2.0);
        int maxHit = context.get(this.baseMaxHitComputable);
        if (context.get(MaxHitLimitComputable.LIMIT_APPLIED).booleanValue()) {
            context.warn("Max hit may be inaccurate due to conflicting effects of a max hit limiter and fang max hit clamping.");
        }
        int attackSpeed = context.get(this.attackSpeedComputable);
        return BaseHitDptComputable.byComponents(effectHitChance, maxHit, attackSpeed);
    }

    @Inject
    public OsmumtensFangDptComputable(EquipmentItemIdsComputable equipmentItemIdsComputable, BaseMaxHitComputable baseMaxHitComputable, HitChanceComputable hitChanceComputable, AttackSpeedComputable attackSpeedComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
        this.baseMaxHitComputable = baseMaxHitComputable;
        this.hitChanceComputable = hitChanceComputable;
        this.attackSpeedComputable = attackSpeedComputable;
    }
}

