/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.multihit;

import com.duckblade.osrs.dpscalc.calc.AttackSpeedComputable;
import com.duckblade.osrs.dpscalc.calc.BaseHitDptComputable;
import com.duckblade.osrs.dpscalc.calc.HitChanceComputable;
import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeOutput;
import com.duckblade.osrs.dpscalc.calc.gearbonus.KerisGearBonus;
import com.duckblade.osrs.dpscalc.calc.maxhit.PreLimitBaseMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.limiters.MaxHitLimitComputable;
import com.duckblade.osrs.dpscalc.calc.multihit.MultiHitDptComputable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class KerisDptComputable
implements MultiHitDptComputable {
    public static final ComputeOutput<Integer> KERIS_MAX_HIT = ComputeOutput.of("MaxHit-Keris");
    private final WeaponComputable weaponComputable;
    private final BaseHitDptComputable baseHitDptComputable;
    private final HitChanceComputable hitChanceComputable;
    private final PreLimitBaseMaxHitComputable preLimitBaseMaxHitComputable;
    private final MaxHitLimitComputable maxHitLimitComputable;
    private final AttackSpeedComputable attackSpeedComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        if (!context.get(ComputeInputs.ATTACK_STYLE).getAttackType().isMelee()) {
            return false;
        }
        return KerisGearBonus.KERIS_IDS.contains(context.get(this.weaponComputable).getItemId()) && context.get(ComputeInputs.DEFENDER_ATTRIBUTES).isKalphite();
    }

    @Override
    public Double compute(ComputeContext context) {
        double baseDps = context.get(this.baseHitDptComputable);
        double hitChance = context.get(this.hitChanceComputable);
        int effectMaxHit = this.maxHitLimitComputable.coerce(3 * context.get(this.preLimitBaseMaxHitComputable), context);
        int attackSpeed = context.get(this.attackSpeedComputable);
        double tripleHitDps = BaseHitDptComputable.byComponents(hitChance, effectMaxHit, attackSpeed);
        context.put(KERIS_MAX_HIT, effectMaxHit);
        return 0.9803921568627451 * baseDps + 0.0196078431372549 * tripleHitDps;
    }

    @Inject
    public KerisDptComputable(WeaponComputable weaponComputable, BaseHitDptComputable baseHitDptComputable, HitChanceComputable hitChanceComputable, PreLimitBaseMaxHitComputable preLimitBaseMaxHitComputable, MaxHitLimitComputable maxHitLimitComputable, AttackSpeedComputable attackSpeedComputable) {
        this.weaponComputable = weaponComputable;
        this.baseHitDptComputable = baseHitDptComputable;
        this.hitChanceComputable = hitChanceComputable;
        this.preLimitBaseMaxHitComputable = preLimitBaseMaxHitComputable;
        this.maxHitLimitComputable = maxHitLimitComputable;
        this.attackSpeedComputable = attackSpeedComputable;
    }
}

