/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.multihit;

import com.duckblade.osrs.dpscalc.calc.AttackSpeedComputable;
import com.duckblade.osrs.dpscalc.calc.BaseHitDptComputable;
import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.HitChanceComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeOutput;
import com.duckblade.osrs.dpscalc.calc.maxhit.PreLimitBaseMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.limiters.MaxHitLimitComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.multihit.MultiHitDptComputable;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class KarilsDptComputable
implements MultiHitDptComputable {
    public static final ComputeOutput<Integer> KARILS_MAX_HIT = ComputeOutput.of("MaxHit-Karils");
    private static final Set<Integer> KARILS_CROSSBOW_IDS = ImmutableSet.of((Object)4734, (Object)4934, (Object)4935, (Object)4936, (Object)4937);
    private static final Set<Integer> KARILS_COIF_IDS = ImmutableSet.of((Object)4732, (Object)4928, (Object)4929, (Object)4930, (Object)4931);
    private static final Set<Integer> KARILS_LEATHERTOP_IDS = ImmutableSet.of((Object)4736, (Object)4940, (Object)4941, (Object)4942, (Object)4943);
    private static final Set<Integer> KARILS_LEATHERSKIRT_IDS = ImmutableSet.of((Object)4738, (Object)4946, (Object)4947, (Object)4948, (Object)4949);
    private static final Set<Integer> AMULET_OF_THE_DAMNED = ImmutableSet.of((Object)12853, (Object)12851);
    private final BaseHitDptComputable baseHitDptComputable;
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;
    private final HitChanceComputable hitChanceComputable;
    private final PreLimitBaseMaxHitComputable preLimitBaseMaxHitComputable;
    private final MaxHitLimitComputable maxHitLimitComputable;
    private final AttackSpeedComputable attackSpeedComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        boolean fullKarils;
        if (context.get(ComputeInputs.ATTACK_STYLE).getAttackType() != AttackType.RANGED) {
            return false;
        }
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        boolean amulet = AMULET_OF_THE_DAMNED.contains(equipment.get(EquipmentInventorySlot.AMULET));
        boolean bl = fullKarils = KARILS_CROSSBOW_IDS.contains(equipment.get(EquipmentInventorySlot.WEAPON)) && KARILS_COIF_IDS.contains(equipment.get(EquipmentInventorySlot.HEAD)) && KARILS_LEATHERTOP_IDS.contains(equipment.get(EquipmentInventorySlot.BODY)) && KARILS_LEATHERSKIRT_IDS.contains(equipment.get(EquipmentInventorySlot.LEGS));
        if (!amulet && fullKarils) {
            context.warn("Karil's equipment only provides a beneficial set effect with the Amulet of the damned.");
        }
        return amulet && fullKarils;
    }

    @Override
    public Double compute(ComputeContext context) {
        double baseDps = context.get(this.baseHitDptComputable);
        int effectMaxHit = this.maxHitLimitComputable.coerce((int)(1.5 * (double)context.get(this.preLimitBaseMaxHitComputable).intValue()), context);
        context.put(KARILS_MAX_HIT, effectMaxHit);
        double hitChance = context.get(this.hitChanceComputable);
        int attackSpeed = context.get(this.attackSpeedComputable);
        double specialDps = BaseHitDptComputable.byComponents(hitChance, effectMaxHit, attackSpeed);
        return 0.75 * baseDps + 0.25 * specialDps;
    }

    @Inject
    public KarilsDptComputable(BaseHitDptComputable baseHitDptComputable, EquipmentItemIdsComputable equipmentItemIdsComputable, HitChanceComputable hitChanceComputable, PreLimitBaseMaxHitComputable preLimitBaseMaxHitComputable, MaxHitLimitComputable maxHitLimitComputable, AttackSpeedComputable attackSpeedComputable) {
        this.baseHitDptComputable = baseHitDptComputable;
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
        this.hitChanceComputable = hitChanceComputable;
        this.preLimitBaseMaxHitComputable = preLimitBaseMaxHitComputable;
        this.maxHitLimitComputable = maxHitLimitComputable;
        this.attackSpeedComputable = attackSpeedComputable;
    }
}

