/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.multihit;

import com.duckblade.osrs.dpscalc.calc.AttackSpeedComputable;
import com.duckblade.osrs.dpscalc.calc.BaseHitDptComputable;
import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.HitChanceComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeOutput;
import com.duckblade.osrs.dpscalc.calc.maxhit.PreLimitBaseMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.limiters.MaxHitLimitComputable;
import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.calc.multihit.MultiHitDptComputable;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Skill;

@Singleton
public class DharoksDptComputable
implements MultiHitDptComputable {
    public static final ComputeOutput<Integer> DHAROKS_MAX_HIT = ComputeOutput.of("MaxHit-Dharoks");
    private static final Set<Integer> DHAROKS_GREATAXE_IDS = ImmutableSet.of((Object)4718, (Object)4886, (Object)4887, (Object)4888, (Object)4889);
    private static final Set<Integer> DHAROKS_HELM_IDS = ImmutableSet.of((Object)4716, (Object)4880, (Object)4881, (Object)4882, (Object)4883);
    private static final Set<Integer> DHAROKS_PLATEBODY_IDS = ImmutableSet.of((Object)4720, (Object)4892, (Object)4893, (Object)4894, (Object)4895);
    private static final Set<Integer> DHAROKS_PLATELEGS_IDS = ImmutableSet.of((Object)4722, (Object)4898, (Object)4899, (Object)4900, (Object)4901);
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;
    private final HitChanceComputable hitChanceComputable;
    private final PreLimitBaseMaxHitComputable preLimitBaseMaxHitComputable;
    private final MaxHitLimitComputable maxHitLimitComputable;
    private final AttackSpeedComputable attackSpeedComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        if (!context.get(ComputeInputs.ATTACK_STYLE).getAttackType().isMelee()) {
            return false;
        }
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        return DHAROKS_GREATAXE_IDS.contains(equipment.get(EquipmentInventorySlot.WEAPON)) && DHAROKS_HELM_IDS.contains(equipment.get(EquipmentInventorySlot.HEAD)) && DHAROKS_PLATEBODY_IDS.contains(equipment.get(EquipmentInventorySlot.BODY)) && DHAROKS_PLATELEGS_IDS.contains(equipment.get(EquipmentInventorySlot.LEGS));
    }

    @Override
    public Double compute(ComputeContext context) {
        Skills attackerSkills = context.get(ComputeInputs.ATTACKER_SKILLS);
        int maxHp = attackerSkills.getLevels().getOrDefault(Skill.HITPOINTS, 99);
        int currentHp = attackerSkills.getTotals().getOrDefault(Skill.HITPOINTS, maxHp);
        double dharokMod = 1.0 + (double)(maxHp - currentHp) / 100.0 * ((double)maxHp / 100.0);
        int effectMaxHit = this.maxHitLimitComputable.coerce((int)((double)context.get(this.preLimitBaseMaxHitComputable).intValue() * dharokMod), context);
        context.put(DHAROKS_MAX_HIT, effectMaxHit);
        double hitChance = context.get(this.hitChanceComputable);
        int attackSpeed = context.get(this.attackSpeedComputable);
        return BaseHitDptComputable.byComponents(hitChance, effectMaxHit, attackSpeed);
    }

    @Inject
    public DharoksDptComputable(EquipmentItemIdsComputable equipmentItemIdsComputable, HitChanceComputable hitChanceComputable, PreLimitBaseMaxHitComputable preLimitBaseMaxHitComputable, MaxHitLimitComputable maxHitLimitComputable, AttackSpeedComputable attackSpeedComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
        this.hitChanceComputable = hitChanceComputable;
        this.preLimitBaseMaxHitComputable = preLimitBaseMaxHitComputable;
        this.maxHitLimitComputable = maxHitLimitComputable;
        this.attackSpeedComputable = attackSpeedComputable;
    }
}

