/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.runelite.api.Skill;

@JsonDeserialize(builder=SkillsBuilder.class)
public final class Skills {
    public static final Skills EMPTY = Skills.builder().build();
    private final Map<Skill, Integer> levels;
    private final Map<Skill, Integer> boosts;

    public SkillsBuilder toBuilderDeep() {
        return this.toBuilder().boosts(new HashMap<Skill, Integer>(this.boosts)).levels(new HashMap<Skill, Integer>(this.levels));
    }

    public Map<Skill, Integer> getTotals() {
        Map<Object, Object> levels = this.levels != null ? this.levels : Collections.emptyMap();
        Map<Object, Object> boosts = this.boosts != null ? this.boosts : Collections.emptyMap();
        return Arrays.stream(Skill.values()).collect(Collectors.toMap(skill -> skill, skill -> levels.getOrDefault(skill, 0) + boosts.getOrDefault(skill, 0)));
    }

    Skills(Map<Skill, Integer> levels, Map<Skill, Integer> boosts) {
        this.levels = levels;
        this.boosts = boosts;
    }

    public static SkillsBuilder builder() {
        return new SkillsBuilder();
    }

    public SkillsBuilder toBuilder() {
        SkillsBuilder builder = new SkillsBuilder();
        if (this.levels != null) {
            builder.levels(this.levels);
        }
        if (this.boosts != null) {
            builder.boosts(this.boosts);
        }
        return builder;
    }

    public Map<Skill, Integer> getLevels() {
        return this.levels;
    }

    public Map<Skill, Integer> getBoosts() {
        return this.boosts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Skills)) {
            return false;
        }
        Skills other = (Skills)o;
        Map<Skill, Integer> this$levels = this.getLevels();
        Map<Skill, Integer> other$levels = other.getLevels();
        if (this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels)) {
            return false;
        }
        Map<Skill, Integer> this$boosts = this.getBoosts();
        Map<Skill, Integer> other$boosts = other.getBoosts();
        return !(this$boosts == null ? other$boosts != null : !((Object)this$boosts).equals(other$boosts));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Skill, Integer> $levels = this.getLevels();
        result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
        Map<Skill, Integer> $boosts = this.getBoosts();
        result = result * 59 + ($boosts == null ? 43 : ((Object)$boosts).hashCode());
        return result;
    }

    public String toString() {
        return "Skills(levels=" + this.getLevels() + ", boosts=" + this.getBoosts() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SkillsBuilder {
        private ArrayList<Skill> levels$key;
        private ArrayList<Integer> levels$value;
        private ArrayList<Skill> boosts$key;
        private ArrayList<Integer> boosts$value;

        SkillsBuilder() {
        }

        public SkillsBuilder level(Skill levelKey, Integer levelValue) {
            if (this.levels$key == null) {
                this.levels$key = new ArrayList();
                this.levels$value = new ArrayList();
            }
            this.levels$key.add(levelKey);
            this.levels$value.add(levelValue);
            return this;
        }

        public SkillsBuilder levels(Map<? extends Skill, ? extends Integer> levels) {
            if (levels == null) {
                throw new NullPointerException("levels cannot be null");
            }
            if (this.levels$key == null) {
                this.levels$key = new ArrayList();
                this.levels$value = new ArrayList();
            }
            for (Map.Entry<? extends Skill, ? extends Integer> $lombokEntry : levels.entrySet()) {
                this.levels$key.add($lombokEntry.getKey());
                this.levels$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SkillsBuilder clearLevels() {
            if (this.levels$key != null) {
                this.levels$key.clear();
                this.levels$value.clear();
            }
            return this;
        }

        public SkillsBuilder boost(Skill boostKey, Integer boostValue) {
            if (this.boosts$key == null) {
                this.boosts$key = new ArrayList();
                this.boosts$value = new ArrayList();
            }
            this.boosts$key.add(boostKey);
            this.boosts$value.add(boostValue);
            return this;
        }

        public SkillsBuilder boosts(Map<? extends Skill, ? extends Integer> boosts) {
            if (boosts == null) {
                throw new NullPointerException("boosts cannot be null");
            }
            if (this.boosts$key == null) {
                this.boosts$key = new ArrayList();
                this.boosts$value = new ArrayList();
            }
            for (Map.Entry<? extends Skill, ? extends Integer> $lombokEntry : boosts.entrySet()) {
                this.boosts$key.add($lombokEntry.getKey());
                this.boosts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SkillsBuilder clearBoosts() {
            if (this.boosts$key != null) {
                this.boosts$key.clear();
                this.boosts$value.clear();
            }
            return this;
        }

        public Skills build() {
            Map<Skill, Integer> boosts;
            Map<Skill, Integer> levels;
            switch (this.levels$key == null ? 0 : this.levels$key.size()) {
                case 0: {
                    levels = Collections.emptyMap();
                    break;
                }
                case 1: {
                    levels = Collections.singletonMap(this.levels$key.get(0), this.levels$value.get(0));
                    break;
                }
                default: {
                    levels = new LinkedHashMap(this.levels$key.size() < 0x40000000 ? 1 + this.levels$key.size() + (this.levels$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.levels$key.size(); ++$i) {
                        levels.put(this.levels$key.get($i), this.levels$value.get($i));
                    }
                    levels = Collections.unmodifiableMap(levels);
                }
            }
            switch (this.boosts$key == null ? 0 : this.boosts$key.size()) {
                case 0: {
                    boosts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    boosts = Collections.singletonMap(this.boosts$key.get(0), this.boosts$value.get(0));
                    break;
                }
                default: {
                    boosts = new LinkedHashMap<Skill, Integer>(this.boosts$key.size() < 0x40000000 ? 1 + this.boosts$key.size() + (this.boosts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.boosts$key.size(); ++$i) {
                        boosts.put(this.boosts$key.get($i), this.boosts$value.get($i));
                    }
                    boosts = Collections.unmodifiableMap(boosts);
                }
            }
            return new Skills(levels, boosts);
        }

        public String toString() {
            return "Skills.SkillsBuilder(levels$key=" + this.levels$key + ", levels$value=" + this.levels$value + ", boosts$key=" + this.boosts$key + ", boosts$value=" + this.boosts$value + ")";
        }
    }
}

