/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.model;

public final class GearBonuses {
    public static final GearBonuses EMPTY = new GearBonuses(1.0, 1.0);
    private final double accuracyBonus;
    private final double strengthBonus;

    public static GearBonuses combine(GearBonuses a, GearBonuses b) {
        return new GearBonuses(a.accuracyBonus * b.accuracyBonus, a.strengthBonus * b.strengthBonus);
    }

    public static GearBonuses symmetric(double bonus) {
        return GearBonuses.of(bonus, bonus);
    }

    public double getAccuracyBonus() {
        return this.accuracyBonus;
    }

    public double getStrengthBonus() {
        return this.strengthBonus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GearBonuses)) {
            return false;
        }
        GearBonuses other = (GearBonuses)o;
        if (Double.compare(this.getAccuracyBonus(), other.getAccuracyBonus()) != 0) {
            return false;
        }
        return Double.compare(this.getStrengthBonus(), other.getStrengthBonus()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $accuracyBonus = Double.doubleToLongBits(this.getAccuracyBonus());
        result = result * 59 + (int)($accuracyBonus >>> 32 ^ $accuracyBonus);
        long $strengthBonus = Double.doubleToLongBits(this.getStrengthBonus());
        result = result * 59 + (int)($strengthBonus >>> 32 ^ $strengthBonus);
        return result;
    }

    public String toString() {
        return "GearBonuses(accuracyBonus=" + this.getAccuracyBonus() + ", strengthBonus=" + this.getStrengthBonus() + ")";
    }

    private GearBonuses(double accuracyBonus, double strengthBonus) {
        this.accuracyBonus = accuracyBonus;
        this.strengthBonus = strengthBonus;
    }

    public static GearBonuses of(double accuracyBonus, double strengthBonus) {
        return new GearBonuses(accuracyBonus, strengthBonus);
    }
}

