/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.model;

import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.DefenderAttributes;
import com.duckblade.osrs.dpscalc.calc.model.DefensiveBonuses;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.calc.model.Prayer;
import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.calc.model.Spell;
import com.duckblade.osrs.dpscalc.calc.model.WeaponCategory;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.runelite.api.EquipmentInventorySlot;

@JsonDeserialize(builder=ComputeInputBuilder.class)
public final class ComputeInput {
    private final Skills attackerSkills;
    private final Map<EquipmentInventorySlot, ItemStats> attackerItems;
    private final Set<Prayer> attackerPrayers;
    private final AttackStyle attackStyle;
    private final Spell spell;
    private final ItemStats blowpipeDarts;
    private final int attackerDistance;
    private final Skills defenderSkills;
    private final DefensiveBonuses defenderBonuses;
    private final DefenderAttributes defenderAttributes;
    private final boolean onSlayerTask;
    private final boolean usingChargeSpell;
    private final boolean usingMarkOfDarkness;
    private final boolean inWilderness;
    private final int raidPartySize;

    public ComputeInputBuilder toBuilderDeep() {
        return this.toBuilder().attackerSkills(this.attackerSkills.toBuilderDeep().build()).attackerItems(new HashMap<EquipmentInventorySlot, ItemStats>(this.attackerItems)).attackerPrayers(new HashSet<Prayer>(this.attackerPrayers)).attackStyle(this.attackStyle.toBuilder().build()).defenderSkills(this.defenderSkills.toBuilderDeep().build()).defenderBonuses(this.defenderBonuses.toBuilder().build()).defenderAttributes(this.defenderAttributes.toBuilder().build());
    }

    private static Skills $default$attackerSkills() {
        return Skills.EMPTY;
    }

    private static AttackStyle $default$attackStyle() {
        return WeaponCategory.UNARMED.getAttackStyles().get(0);
    }

    private static Spell $default$spell() {
        return null;
    }

    private static ItemStats $default$blowpipeDarts() {
        return ItemStats.EMPTY;
    }

    private static int $default$attackerDistance() {
        return 1;
    }

    private static Skills $default$defenderSkills() {
        return Skills.EMPTY;
    }

    private static DefensiveBonuses $default$defenderBonuses() {
        return DefensiveBonuses.EMPTY;
    }

    private static DefenderAttributes $default$defenderAttributes() {
        return DefenderAttributes.EMPTY;
    }

    private static boolean $default$onSlayerTask() {
        return false;
    }

    private static boolean $default$usingChargeSpell() {
        return false;
    }

    private static boolean $default$usingMarkOfDarkness() {
        return false;
    }

    private static boolean $default$inWilderness() {
        return false;
    }

    private static int $default$raidPartySize() {
        return 1;
    }

    ComputeInput(Skills attackerSkills, Map<EquipmentInventorySlot, ItemStats> attackerItems, Set<Prayer> attackerPrayers, AttackStyle attackStyle, Spell spell, ItemStats blowpipeDarts, int attackerDistance, Skills defenderSkills, DefensiveBonuses defenderBonuses, DefenderAttributes defenderAttributes, boolean onSlayerTask, boolean usingChargeSpell, boolean usingMarkOfDarkness, boolean inWilderness, int raidPartySize) {
        this.attackerSkills = attackerSkills;
        this.attackerItems = attackerItems;
        this.attackerPrayers = attackerPrayers;
        this.attackStyle = attackStyle;
        this.spell = spell;
        this.blowpipeDarts = blowpipeDarts;
        this.attackerDistance = attackerDistance;
        this.defenderSkills = defenderSkills;
        this.defenderBonuses = defenderBonuses;
        this.defenderAttributes = defenderAttributes;
        this.onSlayerTask = onSlayerTask;
        this.usingChargeSpell = usingChargeSpell;
        this.usingMarkOfDarkness = usingMarkOfDarkness;
        this.inWilderness = inWilderness;
        this.raidPartySize = raidPartySize;
    }

    public static ComputeInputBuilder builder() {
        return new ComputeInputBuilder();
    }

    public ComputeInputBuilder toBuilder() {
        ComputeInputBuilder builder = new ComputeInputBuilder().attackerSkills(this.attackerSkills).attackStyle(this.attackStyle).spell(this.spell).blowpipeDarts(this.blowpipeDarts).attackerDistance(this.attackerDistance).defenderSkills(this.defenderSkills).defenderBonuses(this.defenderBonuses).defenderAttributes(this.defenderAttributes).onSlayerTask(this.onSlayerTask).usingChargeSpell(this.usingChargeSpell).usingMarkOfDarkness(this.usingMarkOfDarkness).inWilderness(this.inWilderness).raidPartySize(this.raidPartySize);
        if (this.attackerItems != null) {
            builder.attackerItems(this.attackerItems);
        }
        if (this.attackerPrayers != null) {
            builder.attackerPrayers(this.attackerPrayers);
        }
        return builder;
    }

    public Skills getAttackerSkills() {
        return this.attackerSkills;
    }

    public Map<EquipmentInventorySlot, ItemStats> getAttackerItems() {
        return this.attackerItems;
    }

    public Set<Prayer> getAttackerPrayers() {
        return this.attackerPrayers;
    }

    public AttackStyle getAttackStyle() {
        return this.attackStyle;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public ItemStats getBlowpipeDarts() {
        return this.blowpipeDarts;
    }

    public int getAttackerDistance() {
        return this.attackerDistance;
    }

    public Skills getDefenderSkills() {
        return this.defenderSkills;
    }

    public DefensiveBonuses getDefenderBonuses() {
        return this.defenderBonuses;
    }

    public DefenderAttributes getDefenderAttributes() {
        return this.defenderAttributes;
    }

    public boolean isOnSlayerTask() {
        return this.onSlayerTask;
    }

    public boolean isUsingChargeSpell() {
        return this.usingChargeSpell;
    }

    public boolean isUsingMarkOfDarkness() {
        return this.usingMarkOfDarkness;
    }

    public boolean isInWilderness() {
        return this.inWilderness;
    }

    public int getRaidPartySize() {
        return this.raidPartySize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputeInput)) {
            return false;
        }
        ComputeInput other = (ComputeInput)o;
        if (this.getAttackerDistance() != other.getAttackerDistance()) {
            return false;
        }
        if (this.isOnSlayerTask() != other.isOnSlayerTask()) {
            return false;
        }
        if (this.isUsingChargeSpell() != other.isUsingChargeSpell()) {
            return false;
        }
        if (this.isUsingMarkOfDarkness() != other.isUsingMarkOfDarkness()) {
            return false;
        }
        if (this.isInWilderness() != other.isInWilderness()) {
            return false;
        }
        if (this.getRaidPartySize() != other.getRaidPartySize()) {
            return false;
        }
        Skills this$attackerSkills = this.getAttackerSkills();
        Skills other$attackerSkills = other.getAttackerSkills();
        if (this$attackerSkills == null ? other$attackerSkills != null : !((Object)this$attackerSkills).equals(other$attackerSkills)) {
            return false;
        }
        Map<EquipmentInventorySlot, ItemStats> this$attackerItems = this.getAttackerItems();
        Map<EquipmentInventorySlot, ItemStats> other$attackerItems = other.getAttackerItems();
        if (this$attackerItems == null ? other$attackerItems != null : !((Object)this$attackerItems).equals(other$attackerItems)) {
            return false;
        }
        Set<Prayer> this$attackerPrayers = this.getAttackerPrayers();
        Set<Prayer> other$attackerPrayers = other.getAttackerPrayers();
        if (this$attackerPrayers == null ? other$attackerPrayers != null : !((Object)this$attackerPrayers).equals(other$attackerPrayers)) {
            return false;
        }
        AttackStyle this$attackStyle = this.getAttackStyle();
        AttackStyle other$attackStyle = other.getAttackStyle();
        if (this$attackStyle == null ? other$attackStyle != null : !((Object)this$attackStyle).equals(other$attackStyle)) {
            return false;
        }
        Spell this$spell = this.getSpell();
        Spell other$spell = other.getSpell();
        if (this$spell == null ? other$spell != null : !((Object)((Object)this$spell)).equals((Object)other$spell)) {
            return false;
        }
        ItemStats this$blowpipeDarts = this.getBlowpipeDarts();
        ItemStats other$blowpipeDarts = other.getBlowpipeDarts();
        if (this$blowpipeDarts == null ? other$blowpipeDarts != null : !((Object)this$blowpipeDarts).equals(other$blowpipeDarts)) {
            return false;
        }
        Skills this$defenderSkills = this.getDefenderSkills();
        Skills other$defenderSkills = other.getDefenderSkills();
        if (this$defenderSkills == null ? other$defenderSkills != null : !((Object)this$defenderSkills).equals(other$defenderSkills)) {
            return false;
        }
        DefensiveBonuses this$defenderBonuses = this.getDefenderBonuses();
        DefensiveBonuses other$defenderBonuses = other.getDefenderBonuses();
        if (this$defenderBonuses == null ? other$defenderBonuses != null : !((Object)this$defenderBonuses).equals(other$defenderBonuses)) {
            return false;
        }
        DefenderAttributes this$defenderAttributes = this.getDefenderAttributes();
        DefenderAttributes other$defenderAttributes = other.getDefenderAttributes();
        return !(this$defenderAttributes == null ? other$defenderAttributes != null : !((Object)this$defenderAttributes).equals(other$defenderAttributes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAttackerDistance();
        result = result * 59 + (this.isOnSlayerTask() ? 79 : 97);
        result = result * 59 + (this.isUsingChargeSpell() ? 79 : 97);
        result = result * 59 + (this.isUsingMarkOfDarkness() ? 79 : 97);
        result = result * 59 + (this.isInWilderness() ? 79 : 97);
        result = result * 59 + this.getRaidPartySize();
        Skills $attackerSkills = this.getAttackerSkills();
        result = result * 59 + ($attackerSkills == null ? 43 : ((Object)$attackerSkills).hashCode());
        Map<EquipmentInventorySlot, ItemStats> $attackerItems = this.getAttackerItems();
        result = result * 59 + ($attackerItems == null ? 43 : ((Object)$attackerItems).hashCode());
        Set<Prayer> $attackerPrayers = this.getAttackerPrayers();
        result = result * 59 + ($attackerPrayers == null ? 43 : ((Object)$attackerPrayers).hashCode());
        AttackStyle $attackStyle = this.getAttackStyle();
        result = result * 59 + ($attackStyle == null ? 43 : ((Object)$attackStyle).hashCode());
        Spell $spell = this.getSpell();
        result = result * 59 + ($spell == null ? 43 : ((Object)((Object)$spell)).hashCode());
        ItemStats $blowpipeDarts = this.getBlowpipeDarts();
        result = result * 59 + ($blowpipeDarts == null ? 43 : ((Object)$blowpipeDarts).hashCode());
        Skills $defenderSkills = this.getDefenderSkills();
        result = result * 59 + ($defenderSkills == null ? 43 : ((Object)$defenderSkills).hashCode());
        DefensiveBonuses $defenderBonuses = this.getDefenderBonuses();
        result = result * 59 + ($defenderBonuses == null ? 43 : ((Object)$defenderBonuses).hashCode());
        DefenderAttributes $defenderAttributes = this.getDefenderAttributes();
        result = result * 59 + ($defenderAttributes == null ? 43 : ((Object)$defenderAttributes).hashCode());
        return result;
    }

    public String toString() {
        return "ComputeInput(attackerSkills=" + this.getAttackerSkills() + ", attackerItems=" + this.getAttackerItems() + ", attackerPrayers=" + this.getAttackerPrayers() + ", attackStyle=" + this.getAttackStyle() + ", spell=" + this.getSpell() + ", blowpipeDarts=" + this.getBlowpipeDarts() + ", attackerDistance=" + this.getAttackerDistance() + ", defenderSkills=" + this.getDefenderSkills() + ", defenderBonuses=" + this.getDefenderBonuses() + ", defenderAttributes=" + this.getDefenderAttributes() + ", onSlayerTask=" + this.isOnSlayerTask() + ", usingChargeSpell=" + this.isUsingChargeSpell() + ", usingMarkOfDarkness=" + this.isUsingMarkOfDarkness() + ", inWilderness=" + this.isInWilderness() + ", raidPartySize=" + this.getRaidPartySize() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ComputeInputBuilder {
        private boolean attackerSkills$set;
        private Skills attackerSkills$value;
        private ArrayList<EquipmentInventorySlot> attackerItems$key;
        private ArrayList<ItemStats> attackerItems$value;
        private ArrayList<Prayer> attackerPrayers;
        private boolean attackStyle$set;
        private AttackStyle attackStyle$value;
        private boolean spell$set;
        private Spell spell$value;
        private boolean blowpipeDarts$set;
        private ItemStats blowpipeDarts$value;
        private boolean attackerDistance$set;
        private int attackerDistance$value;
        private boolean defenderSkills$set;
        private Skills defenderSkills$value;
        private boolean defenderBonuses$set;
        private DefensiveBonuses defenderBonuses$value;
        private boolean defenderAttributes$set;
        private DefenderAttributes defenderAttributes$value;
        private boolean onSlayerTask$set;
        private boolean onSlayerTask$value;
        private boolean usingChargeSpell$set;
        private boolean usingChargeSpell$value;
        private boolean usingMarkOfDarkness$set;
        private boolean usingMarkOfDarkness$value;
        private boolean inWilderness$set;
        private boolean inWilderness$value;
        private boolean raidPartySize$set;
        private int raidPartySize$value;

        ComputeInputBuilder() {
        }

        public ComputeInputBuilder attackerSkills(Skills attackerSkills) {
            this.attackerSkills$value = attackerSkills;
            this.attackerSkills$set = true;
            return this;
        }

        public ComputeInputBuilder attackerItem(EquipmentInventorySlot attackerItemKey, ItemStats attackerItemValue) {
            if (this.attackerItems$key == null) {
                this.attackerItems$key = new ArrayList();
                this.attackerItems$value = new ArrayList();
            }
            this.attackerItems$key.add(attackerItemKey);
            this.attackerItems$value.add(attackerItemValue);
            return this;
        }

        public ComputeInputBuilder attackerItems(Map<? extends EquipmentInventorySlot, ? extends ItemStats> attackerItems) {
            if (attackerItems == null) {
                throw new NullPointerException("attackerItems cannot be null");
            }
            if (this.attackerItems$key == null) {
                this.attackerItems$key = new ArrayList();
                this.attackerItems$value = new ArrayList();
            }
            for (Map.Entry<? extends EquipmentInventorySlot, ? extends ItemStats> $lombokEntry : attackerItems.entrySet()) {
                this.attackerItems$key.add($lombokEntry.getKey());
                this.attackerItems$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ComputeInputBuilder clearAttackerItems() {
            if (this.attackerItems$key != null) {
                this.attackerItems$key.clear();
                this.attackerItems$value.clear();
            }
            return this;
        }

        public ComputeInputBuilder attackerPrayer(Prayer attackerPrayer) {
            if (this.attackerPrayers == null) {
                this.attackerPrayers = new ArrayList();
            }
            this.attackerPrayers.add(attackerPrayer);
            return this;
        }

        public ComputeInputBuilder attackerPrayers(Collection<? extends Prayer> attackerPrayers) {
            if (attackerPrayers == null) {
                throw new NullPointerException("attackerPrayers cannot be null");
            }
            if (this.attackerPrayers == null) {
                this.attackerPrayers = new ArrayList();
            }
            this.attackerPrayers.addAll(attackerPrayers);
            return this;
        }

        public ComputeInputBuilder clearAttackerPrayers() {
            if (this.attackerPrayers != null) {
                this.attackerPrayers.clear();
            }
            return this;
        }

        public ComputeInputBuilder attackStyle(AttackStyle attackStyle) {
            this.attackStyle$value = attackStyle;
            this.attackStyle$set = true;
            return this;
        }

        public ComputeInputBuilder spell(Spell spell) {
            this.spell$value = spell;
            this.spell$set = true;
            return this;
        }

        public ComputeInputBuilder blowpipeDarts(ItemStats blowpipeDarts) {
            this.blowpipeDarts$value = blowpipeDarts;
            this.blowpipeDarts$set = true;
            return this;
        }

        public ComputeInputBuilder attackerDistance(int attackerDistance) {
            this.attackerDistance$value = attackerDistance;
            this.attackerDistance$set = true;
            return this;
        }

        public ComputeInputBuilder defenderSkills(Skills defenderSkills) {
            this.defenderSkills$value = defenderSkills;
            this.defenderSkills$set = true;
            return this;
        }

        public ComputeInputBuilder defenderBonuses(DefensiveBonuses defenderBonuses) {
            this.defenderBonuses$value = defenderBonuses;
            this.defenderBonuses$set = true;
            return this;
        }

        public ComputeInputBuilder defenderAttributes(DefenderAttributes defenderAttributes) {
            this.defenderAttributes$value = defenderAttributes;
            this.defenderAttributes$set = true;
            return this;
        }

        public ComputeInputBuilder onSlayerTask(boolean onSlayerTask) {
            this.onSlayerTask$value = onSlayerTask;
            this.onSlayerTask$set = true;
            return this;
        }

        public ComputeInputBuilder usingChargeSpell(boolean usingChargeSpell) {
            this.usingChargeSpell$value = usingChargeSpell;
            this.usingChargeSpell$set = true;
            return this;
        }

        public ComputeInputBuilder usingMarkOfDarkness(boolean usingMarkOfDarkness) {
            this.usingMarkOfDarkness$value = usingMarkOfDarkness;
            this.usingMarkOfDarkness$set = true;
            return this;
        }

        public ComputeInputBuilder inWilderness(boolean inWilderness) {
            this.inWilderness$value = inWilderness;
            this.inWilderness$set = true;
            return this;
        }

        public ComputeInputBuilder raidPartySize(int raidPartySize) {
            this.raidPartySize$value = raidPartySize;
            this.raidPartySize$set = true;
            return this;
        }

        public ComputeInput build() {
            Set<Object> attackerPrayers;
            Map<Object, Object> attackerItems;
            switch (this.attackerItems$key == null ? 0 : this.attackerItems$key.size()) {
                case 0: {
                    attackerItems = Collections.emptyMap();
                    break;
                }
                case 1: {
                    attackerItems = Collections.singletonMap(this.attackerItems$key.get(0), this.attackerItems$value.get(0));
                    break;
                }
                default: {
                    attackerItems = new LinkedHashMap(this.attackerItems$key.size() < 0x40000000 ? 1 + this.attackerItems$key.size() + (this.attackerItems$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.attackerItems$key.size(); ++$i) {
                        attackerItems.put(this.attackerItems$key.get($i), this.attackerItems$value.get($i));
                    }
                    attackerItems = Collections.unmodifiableMap(attackerItems);
                }
            }
            switch (this.attackerPrayers == null ? 0 : this.attackerPrayers.size()) {
                case 0: {
                    attackerPrayers = Collections.emptySet();
                    break;
                }
                case 1: {
                    attackerPrayers = Collections.singleton(this.attackerPrayers.get(0));
                    break;
                }
                default: {
                    attackerPrayers = new LinkedHashSet(this.attackerPrayers.size() < 0x40000000 ? 1 + this.attackerPrayers.size() + (this.attackerPrayers.size() - 3) / 3 : Integer.MAX_VALUE);
                    attackerPrayers.addAll(this.attackerPrayers);
                    attackerPrayers = Collections.unmodifiableSet(attackerPrayers);
                }
            }
            Skills attackerSkills$value = this.attackerSkills$value;
            if (!this.attackerSkills$set) {
                attackerSkills$value = ComputeInput.$default$attackerSkills();
            }
            AttackStyle attackStyle$value = this.attackStyle$value;
            if (!this.attackStyle$set) {
                attackStyle$value = ComputeInput.$default$attackStyle();
            }
            Spell spell$value = this.spell$value;
            if (!this.spell$set) {
                spell$value = ComputeInput.$default$spell();
            }
            ItemStats blowpipeDarts$value = this.blowpipeDarts$value;
            if (!this.blowpipeDarts$set) {
                blowpipeDarts$value = ComputeInput.$default$blowpipeDarts();
            }
            int attackerDistance$value = this.attackerDistance$value;
            if (!this.attackerDistance$set) {
                attackerDistance$value = ComputeInput.$default$attackerDistance();
            }
            Skills defenderSkills$value = this.defenderSkills$value;
            if (!this.defenderSkills$set) {
                defenderSkills$value = ComputeInput.$default$defenderSkills();
            }
            DefensiveBonuses defenderBonuses$value = this.defenderBonuses$value;
            if (!this.defenderBonuses$set) {
                defenderBonuses$value = ComputeInput.$default$defenderBonuses();
            }
            DefenderAttributes defenderAttributes$value = this.defenderAttributes$value;
            if (!this.defenderAttributes$set) {
                defenderAttributes$value = ComputeInput.$default$defenderAttributes();
            }
            boolean onSlayerTask$value = this.onSlayerTask$value;
            if (!this.onSlayerTask$set) {
                onSlayerTask$value = ComputeInput.$default$onSlayerTask();
            }
            boolean usingChargeSpell$value = this.usingChargeSpell$value;
            if (!this.usingChargeSpell$set) {
                usingChargeSpell$value = ComputeInput.$default$usingChargeSpell();
            }
            boolean usingMarkOfDarkness$value = this.usingMarkOfDarkness$value;
            if (!this.usingMarkOfDarkness$set) {
                usingMarkOfDarkness$value = ComputeInput.$default$usingMarkOfDarkness();
            }
            boolean inWilderness$value = this.inWilderness$value;
            if (!this.inWilderness$set) {
                inWilderness$value = ComputeInput.$default$inWilderness();
            }
            int raidPartySize$value = this.raidPartySize$value;
            if (!this.raidPartySize$set) {
                raidPartySize$value = ComputeInput.$default$raidPartySize();
            }
            return new ComputeInput(attackerSkills$value, attackerItems, attackerPrayers, attackStyle$value, spell$value, blowpipeDarts$value, attackerDistance$value, defenderSkills$value, defenderBonuses$value, defenderAttributes$value, onSlayerTask$value, usingChargeSpell$value, usingMarkOfDarkness$value, inWilderness$value, raidPartySize$value);
        }

        public String toString() {
            return "ComputeInput.ComputeInputBuilder(attackerSkills$value=" + this.attackerSkills$value + ", attackerItems$key=" + this.attackerItems$key + ", attackerItems$value=" + this.attackerItems$value + ", attackerPrayers=" + this.attackerPrayers + ", attackStyle$value=" + this.attackStyle$value + ", spell$value=" + this.spell$value + ", blowpipeDarts$value=" + this.blowpipeDarts$value + ", attackerDistance$value=" + this.attackerDistance$value + ", defenderSkills$value=" + this.defenderSkills$value + ", defenderBonuses$value=" + this.defenderBonuses$value + ", defenderAttributes$value=" + this.defenderAttributes$value + ", onSlayerTask$value=" + this.onSlayerTask$value + ", usingChargeSpell$value=" + this.usingChargeSpell$value + ", usingMarkOfDarkness$value=" + this.usingMarkOfDarkness$value + ", inWilderness$value=" + this.inWilderness$value + ", raidPartySize$value=" + this.raidPartySize$value + ")";
        }
    }
}

