/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.maxhit.magic;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.model.Spell;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Skill;

@Singleton
public class SpellcastingMaxHitBonusComputable
implements Computable<Integer> {
    private static final int CHAOS_GAUNTLETS = 777;
    private static final Set<Spell> BOLT_SPELLS = ImmutableSet.of((Object)((Object)Spell.WIND_BOLT), (Object)((Object)Spell.WATER_BOLT), (Object)((Object)Spell.EARTH_BOLT), (Object)((Object)Spell.FIRE_BOLT));
    public static final Set<Spell> GOD_SPELLS = ImmutableSet.of((Object)((Object)Spell.CLAWS_OF_GUTHIX), (Object)((Object)Spell.SARADOMIN_STRIKE), (Object)((Object)Spell.FLAMES_OF_ZAMORAK));
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public Integer compute(ComputeContext context) {
        Spell spell = context.get(ComputeInputs.SPELL);
        if (BOLT_SPELLS.contains((Object)spell)) {
            if (777 == context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.GLOVES)) {
                return 3;
            }
        } else if (GOD_SPELLS.contains((Object)spell)) {
            if (context.get(ComputeInputs.USING_CHARGE_SPELL).booleanValue()) {
                return 10;
            }
        } else if (spell == Spell.MAGIC_DART) {
            int magicLvl = context.get(ComputeInputs.ATTACKER_SKILLS).getTotals().get(Skill.MAGIC);
            int weaponId = context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.WEAPON);
            if (weaponId == 21255 && context.get(ComputeInputs.ON_SLAYER_TASK).booleanValue()) {
                return magicLvl / 6 + 3;
            }
            return magicLvl / 10;
        }
        return 0;
    }

    @Inject
    public SpellcastingMaxHitBonusComputable(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

