/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.maxhit.magic;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.maxhit.magic.MagicMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.WeaponCategory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Skill;

@Singleton
public class PoweredStaffMaxHitComputable
implements MagicMaxHitComputable {
    private static final StaffMaxHitProvider SEAS = ctx -> {
        int magicLevel = ctx.get(ComputeInputs.ATTACKER_SKILLS).getTotals().get(Skill.MAGIC);
        return Math.max(1, (magicLevel - 75) / 3 + 20);
    };
    private static final StaffMaxHitProvider WARPED = ctx -> {
        int magicLevel = ctx.get(ComputeInputs.ATTACKER_SKILLS).getTotals().get(Skill.MAGIC);
        return Math.max(1, (8 * magicLevel + 96) / 37);
    };
    private static final StaffMaxHitProvider SWAMP = ctx -> (Integer)SEAS.compute(ctx) + 3;
    private static final StaffMaxHitProvider SANGUINESTI = ctx -> (Integer)SEAS.compute(ctx) + 4;
    private static final StaffMaxHitProvider SHADOW = ctx -> (Integer)SEAS.compute(ctx) + 6;
    private static final Map<Integer, StaffMaxHitProvider> SPELL_MAP = ImmutableMap.builder().put((Object)11907, (Object)SEAS).put((Object)22288, (Object)SEAS).put((Object)11905, (Object)SEAS).put((Object)12899, (Object)SWAMP).put((Object)22292, (Object)SWAMP).put((Object)22323, (Object)SANGUINESTI).put((Object)25731, (Object)SANGUINESTI).put((Object)27275, (Object)SHADOW).put((Object)23898, ignored -> 23).put((Object)23852, ignored -> 23).put((Object)23899, ignored -> 31).put((Object)23853, ignored -> 31).put((Object)23900, ignored -> 39).put((Object)23854, ignored -> 39).put((Object)28585, (Object)WARPED).build();
    private final WeaponComputable weaponComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        AttackStyle attackStyle = context.get(ComputeInputs.ATTACK_STYLE);
        return attackStyle.getAttackType() == AttackType.MAGIC && !attackStyle.isManualCast() && context.get(this.weaponComputable).getWeaponCategory() == WeaponCategory.POWERED_STAFF;
    }

    @Override
    public Integer compute(ComputeContext context) {
        int weaponId = context.get(this.weaponComputable).getItemId();
        StaffMaxHitProvider staffMaxHitProvider = SPELL_MAP.get(weaponId);
        if (staffMaxHitProvider == null) {
            throw new IllegalArgumentException("Missing powered staff max hit provider for weapon id " + weaponId);
        }
        return (Integer)staffMaxHitProvider.compute(context);
    }

    @Inject
    public PoweredStaffMaxHitComputable(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }

    private static interface StaffMaxHitProvider
    extends Computable<Integer> {
    }
}

