/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.maxhit.magic;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.maxhit.magic.MagicMaxHitComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.calc.model.WeaponCategory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Skill;

@Singleton
public class MagicSalamanderMaxHitComputable
implements MagicMaxHitComputable {
    private static final Map<Integer, Integer> SALAMANDER_BASES = ImmutableMap.of((Object)10149, (Object)56, (Object)10146, (Object)59, (Object)10147, (Object)77, (Object)10148, (Object)92);
    private final WeaponComputable weaponComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        AttackStyle attackStyle = context.get(ComputeInputs.ATTACK_STYLE);
        return attackStyle.getAttackType() == AttackType.MAGIC && !attackStyle.isManualCast() && context.get(this.weaponComputable).getWeaponCategory() == WeaponCategory.SALAMANDER;
    }

    @Override
    public Integer compute(ComputeContext context) {
        int weaponId = context.get(this.weaponComputable).getItemId();
        Integer salamanderBase = SALAMANDER_BASES.get(weaponId);
        if (salamanderBase == null) {
            throw new IllegalArgumentException("Missing salamander base for weapon id " + weaponId);
        }
        Skills skills = context.get(ComputeInputs.ATTACKER_SKILLS);
        int magicLevel = skills.getTotals().get(Skill.MAGIC);
        return magicLevel * (salamanderBase + 64) / 640;
    }

    @Inject
    public MagicSalamanderMaxHitComputable(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }
}

