/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.maxhit.magic;

import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.gearbonus.AggregateGearBonusesComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.StrengthBonusComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.magic.MagicMaxHitComputable;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MageMaxHitComputable
implements Computable<Integer> {
    private final Set<MagicMaxHitComputable> maxHitComputables;
    private final StrengthBonusComputable strengthBonusComputable;
    private final AggregateGearBonusesComputable aggregateGearBonusesComputable;

    @Override
    public Integer compute(ComputeContext context) {
        int weaponMaxHit = this.maxHitComputables.stream().filter(mmhc -> mmhc.isApplicable(context)).mapToInt(context::get).findFirst().orElseThrow(() -> new IllegalArgumentException("No magic max hit provider for inputs"));
        double magDmgBonus = 1.0 + (double)context.get(this.strengthBonusComputable).intValue() / 100.0;
        double gearBonus = context.get(this.aggregateGearBonusesComputable).getStrengthBonus();
        double bonus = magDmgBonus * gearBonus;
        return (int)((double)weaponMaxHit * bonus);
    }

    @Inject
    public MageMaxHitComputable(Set<MagicMaxHitComputable> maxHitComputables, StrengthBonusComputable strengthBonusComputable, AggregateGearBonusesComputable aggregateGearBonusesComputable) {
        this.maxHitComputables = maxHitComputables;
        this.strengthBonusComputable = strengthBonusComputable;
        this.aggregateGearBonusesComputable = aggregateGearBonusesComputable;
    }
}

