/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.maxhit.limiters;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.maxhit.limiters.MaxHitLimiter;
import com.duckblade.osrs.dpscalc.calc.model.MaxHitLimit;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class Tier2VampyreImmunities
implements MaxHitLimiter {
    private static final Set<Integer> SILVER_MELEE = ImmutableSet.of((Object)22398, (Object)24697, (Object)24699, (Object)10491, (Object)2961, (Object)2963, (Object[])new Integer[]{22433, 22435, 24693, 24695, 2402, 6745, 6746, 19675, 2952, 7648, 7647, 7646, 7645, 7644, 7643, 7642, 7641, 7640, 7639});
    private static final Set<Integer> SILVER_AMMO = ImmutableSet.of((Object)9145, (Object)9292, (Object)9299, (Object)9306);
    private static final Set<Integer> EFARITAYS_AID = ImmutableSet.of((Object)21140);
    private static final MaxHitLimit EFARITAY_LIMIT = MaxHitLimit.builder().limit(10).warning("Efaritay's aid limits max hit to 10.").build();
    private static final MaxHitLimit TIER_2_IMMUNITY = MaxHitLimit.builder().limit(0).warning("Tier 2 vampyres can only be damaged by silver weaponry or with Efaritay's aid.").build();
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return context.get(ComputeInputs.DEFENDER_ATTRIBUTES).isVampyre2();
    }

    @Override
    public MaxHitLimit compute(ComputeContext context) {
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        boolean efaritay = EFARITAYS_AID.contains(equipment.get(EquipmentInventorySlot.RING));
        switch (context.get(ComputeInputs.ATTACK_STYLE).getAttackType()) {
            case MAGIC: {
                return efaritay ? EFARITAY_LIMIT : TIER_2_IMMUNITY;
            }
            case RANGED: {
                if (SILVER_AMMO.contains(equipment.get(EquipmentInventorySlot.AMMO))) {
                    return MaxHitLimit.UNLIMITED;
                }
                return efaritay ? EFARITAY_LIMIT : TIER_2_IMMUNITY;
            }
        }
        if (SILVER_MELEE.contains(equipment.get(EquipmentInventorySlot.WEAPON))) {
            return MaxHitLimit.UNLIMITED;
        }
        return efaritay ? EFARITAY_LIMIT : TIER_2_IMMUNITY;
    }

    @Inject
    public Tier2VampyreImmunities(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

