/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.maxhit.limiters;

import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.maxhit.limiters.MaxHitLimiter;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.MaxHitLimit;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class CombatStyleImmunityMaxHitLimiter
implements MaxHitLimiter {
    private static final Set<Integer> MELEE_IMMUNE = ImmutableSet.of((Object)3169, (Object)3170, (Object)3171, (Object)3172, (Object)3173, (Object)3174, (Object[])new Integer[]{3175, 3176, 3177, 3178, 3179, 3180, 3181, 3182, 3183, 3162, 3165, 3163, 3164, 2042, 2043, 2044});
    private static final Set<Integer> RANGED_IMMUNE = ImmutableSet.of();
    private static final Set<Integer> MAGE_IMMUNE = ImmutableSet.of((Object)6503);
    private static final Map<AttackType, Set<Integer>> IMMUNITY_MAP = ImmutableMap.of((Object)((Object)AttackType.STAB), MELEE_IMMUNE, (Object)((Object)AttackType.SLASH), MELEE_IMMUNE, (Object)((Object)AttackType.CRUSH), MELEE_IMMUNE, (Object)((Object)AttackType.RANGED), RANGED_IMMUNE, (Object)((Object)AttackType.MAGIC), MAGE_IMMUNE);

    @Override
    public boolean isApplicable(ComputeContext context) {
        return IMMUNITY_MAP.get((Object)context.get(ComputeInputs.ATTACK_STYLE).getAttackType()).contains(context.get(ComputeInputs.DEFENDER_ATTRIBUTES).getNpcId());
    }

    @Override
    public MaxHitLimit compute(ComputeContext context) {
        String npcName = context.get(ComputeInputs.DEFENDER_ATTRIBUTES).getName();
        AttackType attackType = context.get(ComputeInputs.ATTACK_STYLE).getAttackType();
        return MaxHitLimit.builder().limit(0).warning(npcName + " cannot be hit by " + attackType.name().toLowerCase() + " attacks.").build();
    }
}

