/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.maxhit;

import com.duckblade.osrs.dpscalc.calc.AttackerItemStatsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StrengthBonusComputable
implements Computable<Integer> {
    private final AttackerItemStatsComputable attackerItemStatsComputable;

    @Override
    public Integer compute(ComputeContext context) {
        AttackStyle attackStyle = context.get(ComputeInputs.ATTACK_STYLE);
        ItemStats itemStats = context.get(this.attackerItemStatsComputable);
        switch (attackStyle.getAttackType()) {
            case MAGIC: {
                return itemStats.getStrengthMagic();
            }
            case RANGED: {
                return itemStats.getStrengthRanged();
            }
        }
        return itemStats.getStrengthMelee();
    }

    @Inject
    public StrengthBonusComputable(AttackerItemStatsComputable attackerItemStatsComputable) {
        this.attackerItemStatsComputable = attackerItemStatsComputable;
    }
}

