/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.maxhit;

import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.AggregateGearBonusesComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.MeleeEffectiveStrengthLevelComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.RangedEffectiveStrengthLevelComputable;
import com.duckblade.osrs.dpscalc.calc.maxhit.StrengthBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MeleeRangedMaxHitComputable
implements Computable<Integer> {
    private final MeleeEffectiveStrengthLevelComputable meleeStrengthComputable;
    private final RangedEffectiveStrengthLevelComputable rangedStrengthComputable;
    private final StrengthBonusComputable strengthBonusComputable;
    private final AggregateGearBonusesComputable aggregateGearBonusesComputable;

    @Override
    public Integer compute(ComputeContext context) {
        AttackStyle attackStyle = context.get(ComputeInputs.ATTACK_STYLE);
        int effectiveStrength = attackStyle.getAttackType() == AttackType.RANGED ? context.get(this.rangedStrengthComputable).intValue() : context.get(this.meleeStrengthComputable).intValue();
        int strengthBonus = context.get(this.strengthBonusComputable);
        int baseMaxHit = (effectiveStrength * (strengthBonus + 64) + 320) / 640;
        double strengthGearBonus = context.get(this.aggregateGearBonusesComputable).getStrengthBonus();
        return (int)((double)baseMaxHit * strengthGearBonus);
    }

    @Inject
    public MeleeRangedMaxHitComputable(MeleeEffectiveStrengthLevelComputable meleeStrengthComputable, RangedEffectiveStrengthLevelComputable rangedStrengthComputable, StrengthBonusComputable strengthBonusComputable, AggregateGearBonusesComputable aggregateGearBonusesComputable) {
        this.meleeStrengthComputable = meleeStrengthComputable;
        this.rangedStrengthComputable = rangedStrengthComputable;
        this.strengthBonusComputable = strengthBonusComputable;
        this.aggregateGearBonusesComputable = aggregateGearBonusesComputable;
    }
}

