/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.CombatStyle;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.duckblade.osrs.dpscalc.calc.model.Spell;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class TomesGearBonus
implements GearBonusComputable {
    private static final Set<Integer> TOME_OF_FIRE = ImmutableSet.of((Object)20714);
    private static final Set<Spell> FIRE_SPELLS = ImmutableSet.of((Object)((Object)Spell.FIRE_STRIKE), (Object)((Object)Spell.FIRE_BOLT), (Object)((Object)Spell.FIRE_BLAST), (Object)((Object)Spell.FIRE_WAVE), (Object)((Object)Spell.FIRE_SURGE));
    private static final Set<Integer> TOME_OF_WATER = ImmutableSet.of((Object)25574);
    private static final Set<Spell> WATER_SPELLS = ImmutableSet.of((Object)((Object)Spell.WATER_STRIKE), (Object)((Object)Spell.WATER_BOLT), (Object)((Object)Spell.WATER_BLAST), (Object)((Object)Spell.WATER_WAVE), (Object)((Object)Spell.WATER_SURGE));
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        int offHand = context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.SHIELD);
        AttackStyle attackStyle = context.get(ComputeInputs.ATTACK_STYLE);
        boolean usingMagic = attackStyle.getAttackType() == AttackType.MAGIC;
        boolean castingSpell = attackStyle.getCombatStyle() == CombatStyle.AUTOCAST || attackStyle.isManualCast();
        return usingMagic && castingSpell && (TOME_OF_FIRE.contains(offHand) || TOME_OF_WATER.contains(offHand));
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        int offHand = context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.SHIELD);
        Spell spell = context.get(ComputeInputs.SPELL);
        if (TOME_OF_FIRE.contains(offHand) && FIRE_SPELLS.contains((Object)spell)) {
            return GearBonuses.of(1.0, 1.5);
        }
        if (TOME_OF_WATER.contains(offHand) && WATER_SPELLS.contains((Object)spell)) {
            return GearBonuses.symmetric(1.2);
        }
        return GearBonuses.EMPTY;
    }

    @Inject
    public TomesGearBonus(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

