/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.defender.DefenderSkillsComputable;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Skill;

@Singleton
public class TbowGearBonus
implements GearBonusComputable {
    private static final Set<Integer> TBOW_IDS = ImmutableSet.of((Object)20997);
    private static final int LOW_MAGIC_WARN_THRESHOLD = 100;
    private final WeaponComputable weaponComputable;
    private final DefenderSkillsComputable defenderSkillsComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return TBOW_IDS.contains(context.get(this.weaponComputable).getItemId());
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        int defenderMagicAccuracy;
        int defenderMagicLevel = context.get(this.defenderSkillsComputable).getTotals().getOrDefault(Skill.MAGIC, 0);
        int magic = Math.min(250, Math.max(defenderMagicLevel, defenderMagicAccuracy = context.get(ComputeInputs.DEFENDER_ATTRIBUTES).getAccuracyMagic()));
        if (magic < 100) {
            context.warn("Using the twisted bow against low-magic targets incurs negative bonuses.");
        }
        return GearBonuses.of(TbowGearBonus.tbowFormula(magic, true), TbowGearBonus.tbowFormula(magic, false));
    }

    @VisibleForTesting
    static double tbowFormula(int magic, boolean accuracy) {
        double base = accuracy ? 140.0 : 250.0;
        double sub = accuracy ? 10.0 : 14.0;
        double t2 = (3.0 * (double)magic - sub) / 100.0;
        double t3 = Math.pow(3.0 * (double)magic / 10.0 - 10.0 * sub, 2.0) / 100.0;
        return (base + t2 - t3) / 100.0;
    }

    @Inject
    public TbowGearBonus(WeaponComputable weaponComputable, DefenderSkillsComputable defenderSkillsComputable) {
        this.weaponComputable = weaponComputable;
        this.defenderSkillsComputable = defenderSkillsComputable;
    }
}

